/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFormControlStyles, euiFormVariables } from '../form.styles';
export var euiSelectStyles = function euiSelectStyles(euiThemeContext) {
  var formStyles = euiFormControlStyles(euiThemeContext);
  var formVariables = euiFormVariables(euiThemeContext);
  return {
    euiSelect: /*#__PURE__*/css("appearance:none;", formStyles.shared, " &:invalid{", formStyles.invalid, ";}&:focus{", formStyles.focus, ";}&:disabled{", formStyles.disabled, ";}&[readOnly]{", formStyles.readOnly, ";}&:autofill{", formStyles.autoFill, ";};label:euiSelect;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: formStyles.uncompressed,
    compressed: /*#__PURE__*/css(formStyles.compressed, ";label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/css(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/css(formStyles.inGroup, ";label:inGroup;"),
    // Ensure text descenders don't get cut off
    // by making line-height match the input height
    lineHeight: {
      removePadding: "padding-block: 0;",
      uncompressed: "line-height: ".concat(formVariables.controlHeight, ";"),
      compressed: "line-height: ".concat(formVariables.controlCompressedHeight, ";"),
      inGroup: {
        uncompressed: "line-height: ".concat(formVariables.controlLayoutGroupInputHeight),
        compressed: "line-height: ".concat(formVariables.controlLayoutGroupInputCompressedHeight)
      }
    }
  };
};