var _excluded = ["className", "options", "valueOfSelected", "placeholder", "onChange", "isOpen", "isInvalid", "hasDividers", "itemClassName", "itemLayoutAlign", "fullWidth", "popoverProps", "compressed"],
  _excluded2 = ["value", "dropdownDisplay", "inputDisplay"];
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { Component, createRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { htmlIdGenerator, keys } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiInputPopover } from '../../popover';
import { EuiSuperSelectControl } from './super_select_control';
import { EuiSuperSelectItem } from './super_select_item';
import { euiSuperSelectStyles as styles } from './super_select.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var ShiftDirection = /*#__PURE__*/function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
  return ShiftDirection;
}(ShiftDirection || {});
export var EuiSuperSelect = /*#__PURE__*/function (_Component) {
  function EuiSuperSelect() {
    var _this;
    _classCallCheck(this, EuiSuperSelect);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EuiSuperSelect, [].concat(args));
    _defineProperty(_this, "itemNodes", []);
    _defineProperty(_this, "_isMounted", false);
    _defineProperty(_this, "controlButtonRef", /*#__PURE__*/createRef());
    _defineProperty(_this, "describedById", htmlIdGenerator('euiSuperSelect_')('_screenreaderDescribeId'));
    _defineProperty(_this, "state", {
      isPopoverOpen: _this.props.isOpen || false
    });
    _defineProperty(_this, "setItemNode", function (node, index) {
      _this.itemNodes[index] = node;
    });
    _defineProperty(_this, "openPopover", function () {
      _this.setState({
        isPopoverOpen: true
      });
      var focusSelected = function focusSelected() {
        var indexOfSelected = _this.props.options.reduce(function (indexOfSelected, option, index) {
          if (indexOfSelected != null) return indexOfSelected;
          if (option == null) return null;
          return option.value === _this.props.valueOfSelected ? index : null;
        }, null);
        requestAnimationFrame(function () {
          if (!_this._isMounted) {
            return;
          }
          if (_this.props.valueOfSelected != null && indexOfSelected != null) {
            _this.focusItemAt(indexOfSelected);
          } else {
            _this.focusItemAt(0);
          }
          if (_this.props.onFocus) {
            _this.props.onFocus();
          }
        });
      };
      requestAnimationFrame(focusSelected);
    });
    _defineProperty(_this, "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });

      // Refocus back to the toggling control button on popover close
      requestAnimationFrame(function () {
        var _this$controlButtonRe;
        (_this$controlButtonRe = _this.controlButtonRef.current) === null || _this$controlButtonRe === void 0 || _this$controlButtonRe.focus();
      });
      if (_this.props.onBlur) {
        _this.props.onBlur();
      }
    });
    _defineProperty(_this, "itemClicked", function (value) {
      _this.closePopover();
      if (_this.props.onChange) {
        _this.props.onChange(value);
      }
    });
    _defineProperty(_this, "onSelectKeyDown", function (event) {
      // Mimic the ways native `<select>`s can be opened via keypress
      if (event.key === keys.ARROW_UP || event.key === keys.ARROW_DOWN || event.key === keys.SPACE) {
        event.preventDefault();
        event.stopPropagation();
        _this.openPopover();
      }
    });
    _defineProperty(_this, "onItemKeyDown", function (event) {
      switch (event.key) {
        case keys.ESCAPE:
          // close the popover and prevent ancestors from handling
          event.preventDefault();
          event.stopPropagation();
          _this.closePopover();
          break;
        case keys.TAB:
          // Mimic native `<select>` behavior, which selects an item on tab press
          event.preventDefault();
          event.stopPropagation();
          event.target.click();
          break;
        case keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.BACK);
          break;
        case keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.FORWARD);
          break;
      }
    });
    return _this;
  }
  _inherits(EuiSuperSelect, _Component);
  return _createClass(EuiSuperSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.isOpen) {
        this.openPopover();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "focusItemAt",
    value: function focusItemAt(index, direction) {
      var _targetElement;
      var targetElement = this.itemNodes[index];
      // If the current index is disabled, find the next non-disabled element
      while (targetElement && targetElement.disabled) {
        direction === ShiftDirection.BACK ? index-- : index++;
        targetElement = this.itemNodes[index];
      }
      (_targetElement = targetElement) === null || _targetElement === void 0 || _targetElement.focus();
    }
  }, {
    key: "shiftFocus",
    value: function shiftFocus(direction) {
      var currentIndex = this.itemNodes.indexOf(document.activeElement);
      var targetElementIndex;
      if (currentIndex === -1) {
        // somehow the select options has lost focus
        targetElementIndex = 0;
      } else {
        // Note: this component purposely does not cycle arrow key navigation
        // to match native <select> elements
        if (direction === ShiftDirection.BACK) {
          targetElementIndex = currentIndex - 1;
        } else {
          targetElementIndex = currentIndex + 1;
        }
      }
      this.focusItemAt(targetElementIndex, direction);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        className = _this$props.className,
        options = _this$props.options,
        valueOfSelected = _this$props.valueOfSelected,
        placeholder = _this$props.placeholder,
        onChange = _this$props.onChange,
        isOpen = _this$props.isOpen,
        isInvalid = _this$props.isInvalid,
        hasDividers = _this$props.hasDividers,
        itemClassName = _this$props.itemClassName,
        itemLayoutAlign = _this$props.itemLayoutAlign,
        fullWidth = _this$props.fullWidth,
        popoverProps = _this$props.popoverProps,
        compressed = _this$props.compressed,
        rest = _objectWithoutProperties(_this$props, _excluded);
      var popoverClasses = classNames('euiSuperSelect', popoverProps === null || popoverProps === void 0 ? void 0 : popoverProps.className);
      var button = ___EmotionJSX(EuiSuperSelectControl, _extends({
        options: options,
        value: valueOfSelected,
        placeholder: placeholder,
        onClick: this.state.isPopoverOpen ? this.closePopover : this.openPopover,
        onKeyDown: this.onSelectKeyDown,
        className: className,
        fullWidth: fullWidth,
        isInvalid: isInvalid,
        compressed: compressed
      }, rest, {
        buttonRef: this.controlButtonRef,
        isDropdownOpen: this.state.isPopoverOpen
      }));
      var items = options.map(function (option, index) {
        var value = option.value,
          dropdownDisplay = option.dropdownDisplay,
          inputDisplay = option.inputDisplay,
          optionRest = _objectWithoutProperties(option, _excluded2);
        if (value == null) return;
        return ___EmotionJSX(EuiSuperSelectItem, _extends({
          key: index,
          id: String(value),
          className: itemClassName,
          hasDividers: hasDividers,
          layoutAlign: itemLayoutAlign,
          icon: valueOfSelected === value ? 'check' : 'empty',
          onClick: function onClick() {
            return _this2.itemClicked(value);
          },
          onKeyDown: _this2.onItemKeyDown,
          buttonRef: function buttonRef(node) {
            return _this2.setItemNode(node, index);
          },
          "aria-selected": valueOfSelected === value
        }, optionRest), dropdownDisplay || inputDisplay);
      });
      return ___EmotionJSX(EuiInputPopover, _extends({
        closePopover: this.closePopover,
        panelPaddingSize: "none"
      }, popoverProps, {
        className: popoverClasses,
        isOpen: isOpen || this.state.isPopoverOpen,
        input: button,
        fullWidth: fullWidth,
        disableFocusTrap: true // This component handles its own focus manually
      }), ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", {
        id: this.describedById
      }, ___EmotionJSX(EuiI18n, {
        token: "euiSuperSelect.screenReaderAnnouncement",
        default: "You are in a form selector and must select a single option. Use the Up and Down arrow keys to navigate or Escape to close."
      }))), ___EmotionJSX(EuiI18n, {
        token: "euiSuperSelect.ariaLabel",
        default: "Select listbox"
      }, function (ariaLabel) {
        return ___EmotionJSX("div", {
          "aria-label": ariaLabel,
          "aria-describedby": _this2.describedById,
          css: styles.euiSuperSelect__listbox,
          className: "euiSuperSelect__listbox eui-scrollBar",
          role: "listbox",
          "aria-activedescendant": valueOfSelected != null ? String(valueOfSelected) : undefined,
          tabIndex: 0
        }, items);
      }));
    }
  }]);
}(Component);
_defineProperty(EuiSuperSelect, "defaultProps", {
  hasDividers: false,
  fullWidth: false,
  compressed: false,
  isInvalid: false,
  isLoading: false
});
EuiSuperSelect.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  buttonRef: PropTypes.any,
  /**
     * @default false
     */
  compressed: PropTypes.bool,
  /**
     * Expand to fill 100% of the parent.
     * Defaults to `fullWidth` prop of `<EuiForm>`.
     * @default false
     */
  fullWidth: PropTypes.bool,
  /**
     * @default false
     */
  isInvalid: PropTypes.bool,
  /**
     * @default false
     */
  isLoading: PropTypes.bool,
  readOnly: PropTypes.bool,
  name: PropTypes.string,
  /**
       * Placeholder to display when the current selected value is empty.
       */
  placeholder: PropTypes.node,
  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired, PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.element.isRequired]).isRequired).isRequired]),
  /**
       * Pass an array of options that must at least include:
       * `value`: storing unique value of item,
       * `inputDisplay`: what shows inside the form input when selected
       * `dropdownDisplay` (optional): what shows for the item in the dropdown
       */
  options: PropTypes.arrayOf(PropTypes.shape({
    value: PropTypes.any.isRequired,
    inputDisplay: PropTypes.node,
    dropdownDisplay: PropTypes.node,
    disabled: PropTypes.bool,
    "data-test-subj": PropTypes.string
  }).isRequired).isRequired,
  valueOfSelected: PropTypes.any,
  /**
       * Classes for the context menu item
       */
  itemClassName: PropTypes.string,
  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: PropTypes.func,
  onFocus: PropTypes.func,
  onBlur: PropTypes.func,
  /**
       * Change to `true` if you want horizontal lines between options.
       * This is best used when options are multi-line.
       */
  hasDividers: PropTypes.bool,
  /**
       * Change `EuiContextMenuItem` layout position of icon
       */
  itemLayoutAlign: PropTypes.oneOf(["center", "top", "bottom"]),
  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: PropTypes.bool,
  /**
       * Optional props to pass to the underlying [EuiInputPopover](/#/layout/popover#popover-attached-to-input-element).
       * Allows fine-grained control of the popover dropdown menu, including
       * `repositionOnScroll` for EuiSuperSelects used within scrollable containers,
       * and customizing popover panel styling.
       *
       * Does not accept a nested `popoverProps.isOpen` property - use the top level
       * `isOpen` API instead.
       */
  popoverProps: PropTypes.any
};