/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, euiTextTruncate, logicalCSS, logicalCSSWithFallback, logicalTextAlignCSS } from '../../../global_styling';
import { euiFormControlStyles, euiFormVariables } from '../form.styles';
export var euiSuperSelectStyles = {
  euiSuperSelect__listbox: /*#__PURE__*/css(logicalCSS('max-height', '300px'), " ", logicalCSSWithFallback('overflow-y', 'auto'), " ", logicalCSSWithFallback('overflow-x', 'hidden'), ";;label:euiSuperSelect__listbox;")
};
export var euiSuperSelectItemStyles = function euiSuperSelectItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiSuperSelect__item: /*#__PURE__*/css("padding:", euiTheme.size.s, ";", euiFontSize(euiThemeContext, 's'), ";;label:euiSuperSelect__item;"),
    hasDividers: /*#__PURE__*/css("&:not(:last-of-type){", logicalCSS('border-bottom', euiTheme.border.thin), ";};label:hasDividers;")
  };
};
export var euiSuperSelectControlStyles = function euiSuperSelectControlStyles(euiThemeContext) {
  var formStyles = euiFormControlStyles(euiThemeContext);
  var formVariables = euiFormVariables(euiThemeContext);
  return {
    euiSuperSelect__control: /*#__PURE__*/css(formStyles.shared, " display:block;", logicalTextAlignCSS('left'), " ", euiTextTruncate('' // maxWidth is already set by width modifiers below
    ), " &:focus{", formStyles.focus, ";};label:euiSuperSelect__control;"),
    // Since the control is a button and not an actual input, we have to set
    // certain state styles manually instead of relying on CSS selectors
    open: /*#__PURE__*/css(formStyles.focus, ";;label:open;"),
    invalid: /*#__PURE__*/css(formStyles.invalid, ";;label:invalid;"),
    disabled: /*#__PURE__*/css(formStyles.disabled, ";;label:disabled;"),
    readOnly: /*#__PURE__*/css(formStyles.readOnly, ";;label:readOnly;"),
    // Skip the css() on the default height to avoid generating a className
    uncompressed: "\n      ".concat(formStyles.uncompressed, "\n      /* Match line height with inputs */\n      ").concat(logicalCSS('padding-vertical', 0), "\n      line-height: ").concat(formVariables.controlHeight, ";\n    "),
    compressed: /*#__PURE__*/css(formStyles.compressed, logicalCSS('padding-vertical', 0), " line-height:", formVariables.controlCompressedHeight, ";;label:compressed;"),
    // Skip the css() on the default width to avoid generating a className
    formWidth: formStyles.formWidth,
    fullWidth: /*#__PURE__*/css(formStyles.fullWidth, ";label:fullWidth;"),
    // Layout modifiers
    inGroup: /*#__PURE__*/css(formStyles.inGroup, ";label:inGroup;"),
    // Children
    euiSuperSelect__placeholder: /*#__PURE__*/css("color:", formVariables.controlPlaceholderText, ";;label:euiSuperSelect__placeholder;")
  };
};