var _excluded = ["buttonRef", "className", "options", "id", "name", "fullWidth", "isLoading", "isInvalid", "isDropdownOpen", "readOnly", "defaultValue", "compressed", "value", "placeholder", "prepend", "append", "disabled"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useEffect, useState, useMemo } from 'react';
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiFormControlLayout } from '../form_control_layout';
import { useFormContext } from '../eui_form_context';
import { euiSuperSelectControlStyles } from './super_select.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSuperSelectControl = function EuiSuperSelectControl(props) {
  var _useFormContext = useFormContext(),
    defaultFullWidth = _useFormContext.defaultFullWidth;
  var buttonRef = props.buttonRef,
    className = props.className,
    options = props.options,
    id = props.id,
    name = props.name,
    _props$fullWidth = props.fullWidth,
    fullWidth = _props$fullWidth === void 0 ? defaultFullWidth : _props$fullWidth,
    _props$isLoading = props.isLoading,
    isLoading = _props$isLoading === void 0 ? false : _props$isLoading,
    _props$isInvalid = props.isInvalid,
    isInvalid = _props$isInvalid === void 0 ? false : _props$isInvalid,
    isDropdownOpen = props.isDropdownOpen,
    readOnly = props.readOnly,
    defaultValue = props.defaultValue,
    _props$compressed = props.compressed,
    compressed = _props$compressed === void 0 ? false : _props$compressed,
    value = props.value,
    placeholder = props.placeholder,
    prepend = props.prepend,
    append = props.append,
    disabled = props.disabled,
    rest = _objectWithoutProperties(props, _excluded);
  var classes = classNames('euiSuperSelectControl', {
    'euiSuperSelectControl-isLoading': isLoading,
    'euiSuperSelectControl-isInvalid': isInvalid
  }, className);
  var styles = useEuiMemoizedStyles(euiSuperSelectControlStyles);
  var cssStyles = [styles.euiSuperSelect__control, compressed ? styles.compressed : styles.uncompressed, fullWidth ? styles.fullWidth : styles.formWidth, (prepend || append) && styles.inGroup, isDropdownOpen && styles.open, isInvalid && styles.invalid, readOnly && styles.readOnly, disabled && !readOnly && styles.disabled];
  var inputValue = value != null ? value : defaultValue;
  var selectedValue = useMemo(function () {
    if (inputValue != null) {
      var selectedOption = options === null || options === void 0 ? void 0 : options.find(function (option) {
        return option.value === inputValue;
      });
      return selectedOption ? selectedOption.inputDisplay : undefined;
    }
  }, [inputValue, options]);
  var showPlaceholder = !!placeholder && !selectedValue;

  // An extra screen reader workaround is required here to make sure `id`s
  // passed from EuiFormRow are inherited by the targetable <button> element
  var _useState = useState(''),
    _useState2 = _slicedToArray(_useState, 2),
    formLabelId = _useState2[0],
    setFormLabelId = _useState2[1];
  var hasFormLabel = !!formLabelId;
  useEffect(function () {
    if (id) {
      var formRowLabel = "".concat(id, "-label");
      var _hasFormLabel = !!document.getElementById(formRowLabel);
      if (_hasFormLabel) {
        setFormLabelId(formRowLabel);
      }
    }
  }, [id]);
  var buttonId = hasFormLabel ? "".concat(id, "-button") : undefined;
  var ariaLabelledBy = hasFormLabel ? "".concat(buttonId, " ").concat(formLabelId) : undefined;
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX("input", {
    type: "hidden",
    id: id,
    name: name,
    value: String(inputValue !== null && inputValue !== void 0 ? inputValue : ''),
    readOnly: readOnly
  }), ___EmotionJSX(EuiFormControlLayout, {
    isDropdown: true,
    fullWidth: fullWidth,
    isLoading: isLoading,
    isInvalid: isInvalid,
    isDisabled: disabled,
    readOnly: readOnly,
    compressed: compressed,
    prepend: prepend,
    append: append
  }, ___EmotionJSX("button", _extends({
    type: "button",
    className: classes,
    css: cssStyles,
    "aria-haspopup": "listbox",
    "aria-labelledby": ariaLabelledBy,
    id: buttonId,
    disabled: disabled || readOnly
  }, rest, {
    ref: buttonRef
  }), showPlaceholder ? ___EmotionJSX("span", {
    className: "euiSuperSelectControl__placeholder",
    css: styles.euiSuperSelect__placeholder
  }, placeholder) : selectedValue, hasFormLabel &&
  // Add a slight pause between reading out the multiple aria-labelledby elements,
  // mimicking how screen readers handle native <select> elements
  ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, ", ")))));
};