function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { Children, cloneElement, useState, useEffect, useCallback } from 'react';
import PropTypes from "prop-types";
function isMutableRef(ref) {
  return ref != null && ref.hasOwnProperty('current');
}

/**
 * The `EuiValidatableControl` component should be used in scenarios where
 * we can render the validated `<input>` as its direct child.
 */

export var EuiValidatableControl = function EuiValidatableControl(_ref) {
  var isInvalid = _ref.isInvalid,
    children = _ref.children;
  // Note that this must be state and not a ref to cause a rerender/set invalid state on initial mount
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    control = _useState2[0],
    setControl = _useState2[1];
  var child = Children.only(children);
  var childRef = child.ref;
  var replacedRef = useCallback(function (element) {
    setControl(element);

    // Call the original ref, if any
    if (typeof childRef === 'function') {
      childRef(element);
    } else if (isMutableRef(childRef)) {
      childRef.current = element;
    }
  }, [childRef]);
  useSetControlValidity({
    controlEl: control,
    isInvalid: isInvalid
  });
  return /*#__PURE__*/cloneElement(child, {
    ref: replacedRef,
    'aria-invalid': isInvalid || child.props['aria-invalid']
  });
};

/**
 * The `UseEuiValidatableControl` hook should be used in scenarios where
 * we *cannot* control where the validated `<input>` is rendered (e.g., ReactDatePicker)
 * and instead need to access the input via a ref and pass the element in directly
 */
EuiValidatableControl.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  isInvalid: PropTypes.bool,
  children: PropTypes.shape({
    ref: PropTypes.any
  }).isRequired
};
export var useEuiValidatableControl = function useEuiValidatableControl(_ref2) {
  var isInvalid = _ref2.isInvalid,
    controlEl = _ref2.controlEl;
  useSetControlValidity({
    controlEl: controlEl,
    isInvalid: isInvalid
  });
  useEffect(function () {
    if (!controlEl) return;
    if (typeof isInvalid === 'boolean') {
      controlEl.setAttribute('aria-invalid', String(isInvalid));
    } else {
      controlEl.removeAttribute('aria-invalid');
    }
  }, [isInvalid, controlEl]);
};

/**
 * Internal `setCustomValidity` helper
 */
var useSetControlValidity = function useSetControlValidity(_ref3) {
  var controlEl = _ref3.controlEl,
    isInvalid = _ref3.isInvalid;
  useEffect(function () {
    if (controlEl == null || typeof controlEl.setCustomValidity !== 'function') {
      return;
    }
    if (isInvalid) {
      controlEl.setCustomValidity('Invalid');
    } else {
      controlEl.setCustomValidity('');
    }
  }, [isInvalid, controlEl]);
};