/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, euiMaxBreakpoint } from '../../../global_styling';
export var euiHeaderSectionItemStyles = function euiHeaderSectionItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiHeaderSectionItem: /*#__PURE__*/css("position:relative;display:flex;align-items:center;", euiMaxBreakpoint(euiThemeContext, 's'), "{", logicalCSS('min-width', euiTheme.size.xl), ";};label:euiHeaderSectionItem;")
  };
};