function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["className", "alt", "url", "src", "size", "hasShadow", "style", "wrapperProps", "fullScreenIconColor", "allowFullScreen", "caption", "float", "margin", "onFullScreen"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../services';
import { EuiImageWrapper } from './image_wrapper';
import { euiImageStyles } from './image.styles';
import { EuiImageFullScreenWrapper } from './image_fullscreen_wrapper';
import { SIZES } from './image_types';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiImage = function EuiImage(_ref) {
  var className = _ref.className,
    alt = _ref.alt,
    url = _ref.url,
    src = _ref.src,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'original' : _ref$size,
    hasShadow = _ref.hasShadow,
    style = _ref.style,
    wrapperProps = _ref.wrapperProps,
    fullScreenIconColor = _ref.fullScreenIconColor,
    allowFullScreen = _ref.allowFullScreen,
    caption = _ref.caption,
    float = _ref.float,
    margin = _ref.margin,
    onFullScreen = _ref.onFullScreen,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFullScreen = _useState2[0],
    setIsFullScreen = _useState2[1];
  var isNamedSize = typeof size === 'string' && SIZES.includes(size);
  var classes = classNames('euiImage', className);
  var euiTheme = useEuiTheme();
  var styles = euiImageStyles(euiTheme);
  var cssStyles = [styles.euiImage, isNamedSize && styles[size], !isNamedSize && styles.customSize, hasShadow && styles.hasShadow];
  var cssIsFullScreenStyles = [styles.euiImage, styles.isFullScreen];
  var isCustomSize = !isNamedSize && size !== 'original';
  var customSize = typeof size === 'string' ? size : "".concat(size, "px");
  var imageStyleWithCustomSize = isCustomSize ? _objectSpread(_objectSpread({}, style), {}, {
    maxWidth: customSize,
    maxHeight: customSize
  }) : style;
  var isFullWidth = size === 'fullWidth';
  var commonWrapperProps = {
    hasShadow: hasShadow,
    wrapperProps: wrapperProps,
    setIsFullScreen: setIsFullScreen,
    fullScreenIconColor: fullScreenIconColor,
    isFullWidth: isFullWidth,
    allowFullScreen: allowFullScreen,
    alt: alt,
    caption: caption,
    float: float,
    margin: margin,
    onFullScreen: onFullScreen
  };
  var commonImgProps = _objectSpread({
    className: classes,
    src: src || url
  }, rest);
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiImageWrapper, commonWrapperProps, ___EmotionJSX("img", _extends({
    alt: alt,
    css: cssStyles,
    style: imageStyleWithCustomSize
  }, commonImgProps))), allowFullScreen && isFullScreen && ___EmotionJSX(EuiImageFullScreenWrapper, commonWrapperProps, ___EmotionJSX("img", _extends({
    alt: alt,
    css: cssIsFullScreenStyles,
    style: style
  }, commonImgProps))));
};
EuiImage.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Requires either `src` or `url` but defaults to using `src` if both are provided
       */
  src: PropTypes.string,
  url: PropTypes.string,
  /**
       * Alt text should describe the image to aid screen reader users. See
       * https://webaim.org/techniques/alttext/ for a guide on writing
       * effective alt text.
       *
       * If no meaningful description exists, or if the image is adequately
       * described by the surrounding text, pass an empty string.
       */
  alt: PropTypes.string.isRequired,
  /**
       * Provides a visible caption to the image
       */
  caption: PropTypes.node,
  /**
       * Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.
       * `fullWidth` will set the figure to stretch to 100% of its container.
       * `string` and `number` types will max both the width or height, whichever is greater.
       */
  size: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
       * Float the image to the left or right. Useful in large text blocks.
       */
  float: PropTypes.any,
  /**
       * Margin around the image.
       */
  margin: PropTypes.any,
  /**
       * When set to `true` (default) will apply a slight shadow to the image
       */
  hasShadow: PropTypes.bool,
  /**
       * When set to `true` will make the image clickable to a larger version
       */
  allowFullScreen: PropTypes.bool,
  /**
       * Callback when the image is clicked and `allowFullScreen` is `true`
       */
  onFullScreen: PropTypes.func,
  /**
       * Changes the color of the icon that floats above the image when it can be clicked to fullscreen.
       * The default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.
       */
  fullScreenIconColor: PropTypes.oneOf(["light", "dark"]),
  /**
       * Props to add to the wrapping figure element
       */
  wrapperProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  })
};