var _excluded = ["hasAlt", "hasShadow", "children", "onClick", "onKeyDown", "isFullScreen", "isFullWidth", "fullScreenIconColor"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { useEuiTheme } from '../../services';
import { useEuiI18n } from '../i18n';
import { EuiIcon } from '../icon';
import { EuiScreenReaderOnly } from '../accessibility';
import { euiImageButtonStyles, euiImageButtonIconStyles } from './image_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var fullScreenIconColorMap = {
  light: 'ghost',
  dark: 'default'
};
export var EuiImageButton = function EuiImageButton(_ref) {
  var hasAlt = _ref.hasAlt,
    hasShadow = _ref.hasShadow,
    children = _ref.children,
    onClick = _ref.onClick,
    onKeyDown = _ref.onKeyDown,
    isFullScreen = _ref.isFullScreen,
    isFullWidth = _ref.isFullWidth,
    _ref$fullScreenIconCo = _ref.fullScreenIconColor,
    fullScreenIconColor = _ref$fullScreenIconCo === void 0 ? 'light' : _ref$fullScreenIconCo,
    rest = _objectWithoutProperties(_ref, _excluded);
  var euiTheme = useEuiTheme();
  var buttonStyles = euiImageButtonStyles(euiTheme);
  var cssButtonStyles = [buttonStyles.euiImageButton, hasShadow ? buttonStyles.hasShadowHover : buttonStyles.shadowHover, !isFullScreen && isFullWidth && buttonStyles.fullWidth];
  var iconStyles = euiImageButtonIconStyles(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.openFullScreen];
  var openFullScreenInstructions = useEuiI18n('euiImageButton.openFullScreen', 'Click to open this image in fullscreen mode');
  var closeFullScreenInstructions = useEuiI18n('euiImageButton.closeFullScreen', 'Press Escape or click to close image fullscreen mode');
  var iconColor = fullScreenIconColorMap[fullScreenIconColor];
  return ___EmotionJSX(React.Fragment, null, ___EmotionJSX("button", _extends({
    type: "button",
    css: cssButtonStyles,
    onClick: onClick,
    onKeyDown: onKeyDown
  }, rest), isFullScreen &&
  // In fullscreen mode, instructions should come first to allow screen reader
  // users to quickly exit vs. potentially reading out long/unskippable alt text
  ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", null, closeFullScreenInstructions, hasAlt && ' — ')), children, !isFullScreen && ___EmotionJSX("div", {
    css: cssIconStyles
  }, ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("p", null, hasAlt && ' — ', openFullScreenInstructions)), ___EmotionJSX(EuiIcon, {
    type: "fullScreen",
    color: iconColor
  }))));
};
EuiImageButton.propTypes = {
  hasAlt: PropTypes.bool.isRequired,
  onClick: PropTypes.func.isRequired,
  onKeyDown: PropTypes.func,
  isFullWidth: PropTypes.bool.isRequired,
  isFullScreen: PropTypes.bool
};