/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef } from 'react';
import PropTypes from "prop-types";
import { useEuiTheme } from '../../services';
import { euiImageCaptionStyles } from './image_caption.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiImageCaption = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var caption = _ref.caption,
    _ref$isOnOverlayMask = _ref.isOnOverlayMask,
    isOnOverlayMask = _ref$isOnOverlayMask === void 0 ? false : _ref$isOnOverlayMask;
  var euiTheme = useEuiTheme();
  var styles = euiImageCaptionStyles(euiTheme);
  var cssStyles = [styles.euiImageCaption, isOnOverlayMask && styles.isOnOverlayMask];
  return caption ? ___EmotionJSX("figcaption", {
    ref: ref,
    css: cssStyles
  }, caption) : null;
});
EuiImageCaption.propTypes = {
  isOnOverlayMask: PropTypes.bool
};
EuiImageCaption.displayName = 'EuiImageCaption';