function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiFocusTrap } from '../focus_trap';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiIcon } from '../icon';
import { useEuiTheme, keys } from '../../services';
import { useInnerText } from '../inner_text';
import { euiImageFullscreenWrapperStyles } from './image_fullscreen_wrapper.styles';
import { EuiImageButton } from './image_button';
import { euiImageButtonIconStyles } from './image_button.styles';
import { EuiImageCaption } from './image_caption';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiImageFullScreenWrapper = function EuiImageFullScreenWrapper(_ref) {
  var alt = _ref.alt,
    hasShadow = _ref.hasShadow,
    caption = _ref.caption,
    children = _ref.children,
    setIsFullScreen = _ref.setIsFullScreen,
    wrapperProps = _ref.wrapperProps,
    isFullWidth = _ref.isFullWidth,
    fullScreenIconColor = _ref.fullScreenIconColor,
    onFullScreen = _ref.onFullScreen;
  var euiTheme = useEuiTheme();
  var styles = euiImageFullscreenWrapperStyles(euiTheme);
  var cssStyles = [styles.euiImageFullscreenWrapper, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.css];
  var classes = classNames('euiImageFullScreenWrapper', wrapperProps && wrapperProps.className);
  var onKeyDown = function onKeyDown(event) {
    if (event.key === keys.ESCAPE) {
      event.preventDefault();
      event.stopPropagation();
      closeFullScreen();
    }
  };
  var closeFullScreen = function closeFullScreen() {
    setIsFullScreen(false);
    onFullScreen === null || onFullScreen === void 0 || onFullScreen(false);
  };
  var _useInnerText = useInnerText(),
    _useInnerText2 = _slicedToArray(_useInnerText, 2),
    optionalCaptionRef = _useInnerText2[0],
    optionalCaptionText = _useInnerText2[1];
  var iconStyles = euiImageButtonIconStyles(euiTheme);
  var cssIconStyles = [iconStyles.euiImageButton__icon, iconStyles.closeFullScreen];
  return ___EmotionJSX(EuiOverlayMask, {
    "data-test-subj": "fullScreenOverlayMask"
  }, ___EmotionJSX(EuiFocusTrap, {
    scrollLock: true,
    preventScrollOnFocus: true,
    onClickOutside: closeFullScreen
  }, ___EmotionJSX(React.Fragment, null, ___EmotionJSX("figure", _extends({
    "aria-label": optionalCaptionText
  }, wrapperProps, {
    className: classes,
    css: cssStyles
  }), ___EmotionJSX(EuiImageButton, {
    hasAlt: !!alt,
    hasShadow: hasShadow,
    onClick: closeFullScreen,
    onKeyDown: onKeyDown,
    "data-test-subj": "deactivateFullScreenButton",
    isFullScreen: true,
    isFullWidth: isFullWidth,
    fullScreenIconColor: fullScreenIconColor
  }, children), ___EmotionJSX(EuiImageCaption, {
    caption: caption,
    ref: optionalCaptionRef,
    isOnOverlayMask: true
  })), ___EmotionJSX(EuiIcon, {
    type: "fullScreenExit",
    color: "ghost",
    css: cssIconStyles
  }))));
};
EuiImageFullScreenWrapper.propTypes = {
  isFullWidth: PropTypes.bool.isRequired,
  setIsFullScreen: PropTypes.func.isRequired
};