/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalTextAlignCSS, euiCanAnimate, euiAnimSlideInUp } from '../../global_styling';
export var euiImageFullscreenWrapperStyles = function euiImageFullscreenWrapperStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiImageFullscreenWrapper: /*#__PURE__*/css(logicalCSS('max-height', '80vh'), " ", logicalCSS('max-width', '80vw'), " ", logicalTextAlignCSS('center'), "line-height:0;", euiCanAnimate, "{animation:", euiAnimSlideInUp(euiTheme.size.xxxxl), " ", euiTheme.animation.extraSlow, " ", euiTheme.animation.bounce, ";}&:hover [class*='euiImageCaption']{text-decoration:underline;};label:euiImageFullscreenWrapper;"),
    // Sizes
    fullWidth: /*#__PURE__*/css(logicalCSS('width', '100%'), ";;label:fullWidth;")
  };
};