/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiTitleStyles } from '../title/title.styles';
export var euiInlineEditTitleStyles = function euiInlineEditTitleStyles(euiThemeContext) {
  var titleFontStyles = euiTitleStyles(euiThemeContext);
  return {
    euiInlineEditTitle: /*#__PURE__*/css(";label:euiInlineEditTitle;"),
    fontSize: {
      xxxs: /*#__PURE__*/css(".euiFieldText{", titleFontStyles.xxxs, ";};label:xxxs;"),
      xxs: /*#__PURE__*/css(".euiFieldText{", titleFontStyles.xxs, ";};label:xxs;"),
      xs: /*#__PURE__*/css(".euiFieldText{", titleFontStyles.xs, ";};label:xs;"),
      s: /*#__PURE__*/css(".euiFieldText{", titleFontStyles.s, ";};label:s;"),
      m: /*#__PURE__*/css(".euiFieldText{", titleFontStyles.m, ";};label:m;"),
      l: /*#__PURE__*/css(".euiFieldText{", titleFontStyles.l, ";};label:l;")
    }
  };
};