function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiKeyPadMenu } from './key_pad_menu';
import { EuiKeyPadMenuItem } from './key_pad_menu_item';
import { EuiIcon } from '../icon';
import { useGeneratedHtmlId } from '../../services';
import { jsx as ___EmotionJSX } from "@emotion/react";
var KeyPadMenu = function KeyPadMenu() {
  var keypadButtonId__1 = useGeneratedHtmlId({
    prefix: 'keypadButton',
    suffix: 'first'
  });
  var keypadButtonId__2 = useGeneratedHtmlId({
    prefix: 'keypadButton',
    suffix: 'second'
  });
  var keypadButtonId__3 = useGeneratedHtmlId({
    prefix: 'keypadButton',
    suffix: 'third'
  });
  var keypadButtonId__4 = useGeneratedHtmlId({
    prefix: 'keypadButton',
    suffix: 'fourth'
  });
  var keypadButtonId__5 = useGeneratedHtmlId({
    prefix: 'keypadButton',
    suffix: 'fifth'
  });
  var keypadButtonId__6 = useGeneratedHtmlId({
    prefix: 'keypadButton',
    suffix: 'sixth'
  });
  var _useState = useState(keypadButtonId__6),
    _useState2 = _slicedToArray(_useState, 2),
    selectedID = _useState2[0],
    setSelectedID = _useState2[1];
  return ___EmotionJSX("div", {
    "aria-label": "Menu keypad"
  }, ___EmotionJSX(EuiKeyPadMenu, null, ___EmotionJSX(EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-1",
    id: keypadButtonId__1,
    label: "Button 1",
    isSelected: selectedID === keypadButtonId__1,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__1);
    }
  }, ___EmotionJSX(EuiIcon, {
    type: "grid",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-2",
    id: keypadButtonId__2,
    label: "Button 2",
    isSelected: selectedID === keypadButtonId__2,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__2);
    }
  }, ___EmotionJSX(EuiIcon, {
    type: "grid",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-button-3",
    id: keypadButtonId__3,
    label: "Button 3",
    isSelected: selectedID === keypadButtonId__3,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__3);
    }
  }, ___EmotionJSX(EuiIcon, {
    type: "grid",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-1",
    id: keypadButtonId__4,
    label: "Link 1",
    href: "#/navigation/key-pad-menu",
    isSelected: selectedID === keypadButtonId__4,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__4);
    }
  }, ___EmotionJSX(EuiIcon, {
    type: "link",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-2",
    id: keypadButtonId__5,
    label: "Link 2",
    href: "#/navigation/key-pad-menu",
    isSelected: selectedID === keypadButtonId__5,
    onClick: function onClick() {
      return setSelectedID(keypadButtonId__5);
    }
  }, ___EmotionJSX(EuiIcon, {
    type: "link",
    size: "l"
  })), ___EmotionJSX(EuiKeyPadMenuItem, {
    "data-test-subj": "cy-keypad-link-3",
    id: keypadButtonId__6,
    label: "Disabled Link 3",
    isDisabled: true,
    isSelected: selectedID === keypadButtonId__6
  }, ___EmotionJSX(EuiIcon, {
    type: "link",
    size: "l"
  }))));
};
beforeEach(function () {
  cy.realMount(___EmotionJSX(KeyPadMenu, null));
  cy.get('div[aria-label="Menu keypad"]').should('exist');
});
describe('EuiKeyPadMenu', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations on item click', function () {
      cy.get('a[data-test-subj="cy-keypad-link-2"]').realClick();
      cy.get('a[data-test-subj="cy-keypad-link-2"]').should('have.attr', 'aria-current', 'true');
      cy.checkAxe();
    });
    it('has zero violations on item keypress', function () {
      cy.repeatRealPress('Tab', 3);
      cy.get('button[data-test-subj="cy-keypad-button-3"]').should('have.focus');
      cy.realPress('Space');
      cy.get('button[data-test-subj="cy-keypad-button-3"]').should('have.attr', 'aria-pressed', 'true');
      cy.checkAxe();
      cy.realPress(['Shift', 'Tab']);
      cy.get('button[data-test-subj="cy-keypad-button-2"]').should('have.attr', 'aria-pressed', 'false');
      cy.realPress('Space');
      cy.get('button[data-test-subj="cy-keypad-button-2"]').invoke('attr', 'aria-pressed').should('equal', 'true');
      cy.get('button[data-test-subj="cy-keypad-button-3"]').invoke('attr', 'aria-pressed').should('equal', 'false');
      cy.checkAxe();
    });
  });
});