var _excluded = ["children", "className", "checkable"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiFormLabel } from '../form/form_label/form_label';
import { euiKeyPadMenuStyles } from './key_pad_menu.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiKeyPadMenu = function EuiKeyPadMenu(_ref) {
  var _checkable$legendProp;
  var children = _ref.children,
    className = _ref.className,
    checkable = _ref.checkable,
    rest = _objectWithoutProperties(_ref, _excluded);
  var hasCheckableConfig = _typeof(checkable) === 'object';
  var classes = classNames('euiKeyPadMenu', className);
  var styles = useEuiMemoizedStyles(euiKeyPadMenuStyles);
  var cssStyles = [styles.euiKeyPadMenu];
  var legendCssStyles = [styles.euiKeyPadMenu__legend, hasCheckableConfig && (checkable === null || checkable === void 0 || (_checkable$legendProp = checkable.legendProps) === null || _checkable$legendProp === void 0 ? void 0 : _checkable$legendProp.css)];
  var legend = hasCheckableConfig && checkable.legend ? ___EmotionJSX(EuiFormLabel, _extends({}, checkable.legendProps, {
    css: legendCssStyles,
    type: "legend"
  }), checkable.legend) : undefined;
  return checkable ? ___EmotionJSX("fieldset", _extends({
    css: cssStyles,
    className: classes,
    "aria-label": hasCheckableConfig ? checkable.ariaLegend : undefined
  }, rest), legend, children) : ___EmotionJSX("ul", _extends({
    css: cssStyles,
    className: classes
  }, rest), React.Children.map(children, function (child) {
    return ___EmotionJSX("li", null, child);
  }));
};
EuiKeyPadMenu.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Renders the the group as a `fieldset`.
       * Set to `true` to customize the labelling, or pass an #EuiKeyPadMenuCheckableProps object to add a `legend` or `ariaLegend`
       */
  checkable: PropTypes.oneOfType([PropTypes.shape({
    /**
         * Rendered within a `legend` to label the `fieldset`.
         * To create a visually hidden legend, use `ariaLegend`
         */
    legend: PropTypes.node,
    /**
         * Pass through props to a `EuiFormLabel` component, except for `type`
         */
    legendProps: PropTypes.any,
    /**
         * Custom aria-attribute for creating a *visually hidden* legend.
         * To create a visible legend, use `legend`
         */
    ariaLegend: PropTypes.string
  }).isRequired, PropTypes.oneOf([true])])
};