var _excluded = ["id", "isSelected", "isDisabled", "label", "children", "className", "betaBadgeLabel", "betaBadgeTooltipContent", "betaBadgeIconType", "betaBadgeTooltipProps", "href", "rel", "target", "buttonRef", "checkable", "name", "value", "disabled", "onChange"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles, getSecureRelForTarget, useGeneratedHtmlId } from '../../services';
import { EuiBetaBadge } from '../badge/beta_badge';
import { EuiRadio, EuiCheckbox } from '../form';
import { validateHref } from '../../services/security/href_validator';
import { EuiToolTip } from '../tool_tip';
import { euiKeyPadMenuItemStyles, euiKeyPadMenuItemChildStyles } from './key_pad_menu_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiKeyPadMenuItem = function EuiKeyPadMenuItem(_ref) {
  var id = _ref.id,
    isSelected = _ref.isSelected,
    _isDisabled = _ref.isDisabled,
    label = _ref.label,
    children = _ref.children,
    className = _ref.className,
    betaBadgeLabel = _ref.betaBadgeLabel,
    betaBadgeTooltipContent = _ref.betaBadgeTooltipContent,
    betaBadgeIconType = _ref.betaBadgeIconType,
    betaBadgeTooltipProps = _ref.betaBadgeTooltipProps,
    href = _ref.href,
    rel = _ref.rel,
    target = _ref.target,
    buttonRef = _ref.buttonRef,
    checkable = _ref.checkable,
    name = _ref.name,
    value = _ref.value,
    disabled = _ref.disabled,
    _onChange = _ref.onChange,
    rest = _objectWithoutProperties(_ref, _excluded);
  var isHrefValid = !href || validateHref(href);
  var isDisabled = disabled || _isDisabled || !isHrefValid;
  var styles = useEuiMemoizedStyles(euiKeyPadMenuItemStyles);
  var cssStyles = [styles.euiKeyPadMenuItem, !isDisabled ? styles.enabled : styles.disabled.disabled, isSelected && (!isDisabled ? styles.selected : styles.disabled.selected)];
  var classes = classNames('euiKeyPadMenuItem', className);
  var Element = href && !isDisabled ? 'a' : 'button';
  if (checkable) Element = 'label';
  var itemId = useGeneratedHtmlId({
    conditionalId: id
  });
  var childStyles = useEuiMemoizedStyles(euiKeyPadMenuItemChildStyles);
  var checkableElement = useMemo(function () {
    if (!checkable) return;
    var cssStyles = [childStyles.euiKeyPadMenuItem__checkableInput, !isSelected && isDisabled && childStyles.hideCheckableInput, !isSelected && !isDisabled && childStyles.showCheckableInputOnInteraction];
    var sharedProps = {
      id: itemId,
      className: 'euiKeyPadMenuItem__checkableInput',
      css: cssStyles,
      checked: isSelected,
      disabled: isDisabled,
      name: name
    };
    if (checkable === 'single') {
      return ___EmotionJSX(EuiRadio, _extends({}, sharedProps, {
        value: value,
        onChange: function onChange() {
          return _onChange(itemId, value);
        }
      }));
    } else {
      return ___EmotionJSX(EuiCheckbox, _extends({}, sharedProps, {
        onChange: function onChange() {
          return _onChange(itemId);
        }
      }));
    }
  }, [checkable, isDisabled, isSelected, _onChange, value, name, itemId, childStyles]);
  var betaBadge = useMemo(function () {
    if (!betaBadgeLabel) return;
    return ___EmotionJSX(EuiBetaBadge
    // Since we move the tooltip contents to a wrapping EuiToolTip,
    // this badge is purely visual therefore we can safely hide it from screen readers
    , {
      "aria-hidden": "true",
      size: "s",
      color: "subdued",
      className: "euiKeyPadMenuItem__betaBadge",
      css: childStyles.euiKeyPadMenuItem__betaBadge,
      label: betaBadgeLabel.charAt(0),
      iconType: betaBadgeIconType
    });
  }, [betaBadgeLabel, betaBadgeIconType, childStyles]);
  var relObj = {};
  if (href && !isDisabled) {
    relObj.href = href;
    relObj.rel = getSecureRelForTarget({
      href: href,
      target: target,
      rel: rel
    });
    relObj.target = target;
    relObj['aria-current'] = isSelected ? isSelected : undefined;
  } else if (checkable) {
    relObj.htmlFor = itemId;
  } else {
    relObj.disabled = isDisabled;
    relObj.type = 'button';
    relObj['aria-pressed'] = isSelected;
  }
  var button = ___EmotionJSX(Element, _extends({
    className: classes,
    css: cssStyles
  }, relObj, rest, {
    // Unable to get past `LegacyRef` conflicts
    ref: buttonRef
  }), ___EmotionJSX("span", {
    className: "euiKeyPadMenuItem__inner",
    css: childStyles.euiKeyPadMenuItem__inner
  }, checkable ? checkableElement : betaBadge, ___EmotionJSX("span", {
    className: "euiKeyPadMenuItem__icon",
    css: childStyles.euiKeyPadMenuItem__icon
  }, children), ___EmotionJSX("span", {
    className: "euiKeyPadMenuItem__label",
    css: childStyles.euiKeyPadMenuItem__label
  }, label)));
  return betaBadgeLabel ? ___EmotionJSX(EuiToolTip, _extends({}, betaBadgeTooltipProps, {
    title: betaBadgeLabel,
    content: betaBadgeTooltipContent,
    delay: "long"
  }), button) : button;
};
EuiKeyPadMenuItem.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * One will be generated if not provided
     */
  /**
     * One will be generated if not provided
     */
  /**
     * One will be generated if not provided
     */
  id: PropTypes.string,
  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  /**
     * Pass an EuiIcon, preferrably `size="l"`
     */
  children: PropTypes.node.isRequired,
  isDisabled: PropTypes.bool,
  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  /**
     * Indicate if an item is the current one.
     * Be sure to use `true` AND `false` when acting as a toggle to ensure the attribute is added for both states
     */
  isSelected: PropTypes.bool,
  /**
     * The text to display beneath the icon
     */
  /**
     * The text to display beneath the icon
     */
  /**
     * The text to display beneath the icon
     */
  label: PropTypes.node.isRequired,
  /**
     * Beta badges are unavailable if the item is checkable
     */
  /**
     * Beta badges are unavailable if the item is checkable
     */
  /**
         * Type `'multi'` renders the item as a `<label>` and
         * adds a checkbox.
         */
  /**
         * Type `'single'` renders the item as a `<label>` and
         * adds a radio element.
         */
  checkable: PropTypes.oneOfType([PropTypes.oneOfType([PropTypes.oneOf(["single"]).isRequired, PropTypes.oneOf(["multi"]).isRequired]).isRequired, PropTypes.oneOf([undefined])]),
  /**
         * The `name` attribute for radio inputs;
         * Required in order to group properly
         */
  name: PropTypes.string,
  /**
         * The value of the radio input for 'single'
         */
  value: PropTypes.string,
  /**
         * Multi: Returns the `id` of the clicked option
         */
  /**
         * Single: Returns the `id` of the clicked option and the `value`
         */
  onChange: PropTypes.func,
  href: PropTypes.string,
  onClick: PropTypes.func,
  buttonRef: PropTypes.any,
  rel: PropTypes.string,
  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  /**
     * Add a badge to the card to label it as "Beta" or other non-GA state
     */
  betaBadgeLabel: PropTypes.string,
  /**
     * Supply an icon type if the badge should just be an icon
     */
  betaBadgeIconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  /**
     * Add a description to the beta badge (will appear in a tooltip)
     */
  betaBadgeTooltipContent: PropTypes.node,
  /**
     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
     */
  /**
     * Extends the wrapping EuiToolTip props when `betaBadgeLabel` is provided
     */
  betaBadgeTooltipProps: PropTypes.any
};