/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { logicalCSS, logicalSizeCSS, euiCanAnimate, euiFontSize } from '../../global_styling';
import { euiShadow } from '../../themes/amsterdam/global_styling/mixins';
import { euiScreenReaderOnly } from '../accessibility';
import { euiKeyPadMenuVariables } from './key_pad_menu.styles';
export var euiKeyPadMenuItemStyles = function euiKeyPadMenuItemStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiKeyPadMenuVariabl = euiKeyPadMenuVariables(euiThemeContext),
    euiKeyPadMenuSize = _euiKeyPadMenuVariabl.euiKeyPadMenuSize;
  return {
    euiKeyPadMenuItem: /*#__PURE__*/css("display:block;padding:", euiTheme.size.xs, ";", logicalSizeCSS(euiKeyPadMenuSize), " border-radius:", euiTheme.border.radius.medium, ";color:", euiTheme.colors.text, ";", euiCanAnimate, "{transition:background-color ", euiTheme.animation.fast, " ease-in,box-shadow ", euiTheme.animation.fast, " ease-in;};label:euiKeyPadMenuItem;"),
    enabled: /*#__PURE__*/css("&:hover,&:focus,&:focus-within{cursor:pointer;text-decoration:underline;", euiShadow(euiThemeContext, 's'), " ", euiCanAnimate, "{.euiKeyPadMenuItem__icon{transform:translateY(0);}}}&:focus{background-color:", euiTheme.focus.backgroundColor, ";box-shadow:none;};label:enabled;"),
    selected: /*#__PURE__*/css("color:", euiTheme.colors.title, ";background-color:", euiTheme.focus.backgroundColor, ";&,&:hover,&:focus,&:focus-within{color:", euiTheme.colors.primaryText, ";};label:selected;"),
    disabled: {
      disabled: /*#__PURE__*/css("cursor:not-allowed;color:", euiTheme.colors.disabledText, ";.euiKeyPadMenuItem__icon{filter:grayscale(100%);svg *{fill:", euiTheme.colors.disabledText, ";}};label:disabled;"),
      selected: /*#__PURE__*/css("background-color:", transparentize(euiTheme.colors.disabled, euiTheme.focus.transparency), ";;label:selected;")
    }
  };
};
export var euiKeyPadMenuItemChildStyles = function euiKeyPadMenuItemChildStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var topRightChildren = "\n    z-index: 3;\n    position: absolute;\n    ".concat(logicalCSS('top', euiTheme.size.xs), "\n    ").concat(logicalCSS('right', euiTheme.size.xs), "\n  ");
  return {
    euiKeyPadMenuItem__inner: /*#__PURE__*/css(logicalSizeCSS('100%'), " display:flex;flex-direction:column;align-items:center;justify-content:center;position:relative;;label:euiKeyPadMenuItem__inner;"),
    euiKeyPadMenuItem__icon: /*#__PURE__*/css(logicalCSS('margin-bottom', euiTheme.size.m), " transform:translateY(2px);", euiCanAnimate, "{transition:transform ", euiTheme.animation.normal, " ", euiTheme.animation.bounce, ";};label:euiKeyPadMenuItem__icon;"),
    euiKeyPadMenuItem__label: /*#__PURE__*/css(euiFontSize(euiThemeContext, 'xs'), " font-weight:", euiTheme.font.weight.semiBold, ";text-align:center;;label:euiKeyPadMenuItem__label;"),
    euiKeyPadMenuItem__betaBadge: /*#__PURE__*/css(topRightChildren, ";;label:euiKeyPadMenuItem__betaBadge;"),
    euiKeyPadMenuItem__checkableInput: /*#__PURE__*/css(topRightChildren, " transform:scale(.75);transform-origin:top right;&&{position:absolute;};label:euiKeyPadMenuItem__checkableInput;"),
    showCheckableInputOnInteraction: /*#__PURE__*/css(".euiKeyPadMenuItem:not(:hover, :focus, :focus-within) &{", euiScreenReaderOnly(), ";};label:showCheckableInputOnInteraction;"),
    hideCheckableInput: /*#__PURE__*/css(euiScreenReaderOnly(), ";;label:hideCheckableInput;")
  };
};