var _excluded = ["target", "external"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { useEuiMemoizedStyles } from '../../services';
import { logicalStyle } from '../../global_styling';
import { EuiIcon } from '../icon';
import { EuiI18n } from '../i18n';
import { EuiScreenReaderOnly } from '../accessibility';

/**
 * DRY util for indicating external links both via icon and to
 * screen readers. Used internally by at EuiLink and EuiListGroupItem
 */
import { jsx as ___EmotionJSX } from "@emotion/react";
var iconStyle = function iconStyle(_ref) {
  var euiTheme = _ref.euiTheme;
  return logicalStyle('margin-left', euiTheme.size.xs);
};
export var EuiExternalLinkIcon = function EuiExternalLinkIcon(_ref2) {
  var target = _ref2.target,
    external = _ref2.external,
    rest = _objectWithoutProperties(_ref2, _excluded);
  var iconCssStyle = useEuiMemoizedStyles(iconStyle);
  var showExternalLinkIcon = target === '_blank' && external !== false || external === true;
  return ___EmotionJSX(React.Fragment, null, showExternalLinkIcon && ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiIcon, _extends({
    css: iconCssStyle,
    size: "s",
    type: "popout",
    role: "presentation"
  }, rest)), target === '_blank' ? ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, ___EmotionJSX(EuiI18n, {
    token: "euiExternalLinkIcon.newTarget.screenReaderOnlyText",
    default: "(external, opens in a new tab or window)"
  }))) : ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("span", null, ___EmotionJSX(EuiI18n, {
    token: "euiExternalLinkIcon.externalTarget.screenReaderOnlyText",
    default: "(external)"
  }))))));
};
EuiExternalLinkIcon.propTypes = {
  target: PropTypes.any,
  /**
     * Set to true to show an icon indicating that it is an external link;
     * Defaults to true if `target="_blank"`
     */
  external: PropTypes.bool
};