function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS } from '../../global_styling';
import { euiFormMaxWidth } from '../form/form.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1urrzow-flush",
  styles: "padding:0;border:none;.euiListGroupItem{border-radius:0;};label:flush;"
} : {
  name: "1urrzow-flush",
  styles: "padding:0;border:none;.euiListGroupItem{border-radius:0;};label:flush;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "2tmo78-euiListGroup",
  styles: "display:flex;flex-direction:column;label:euiListGroup;"
} : {
  name: "2tmo78-euiListGroup",
  styles: "display:flex;flex-direction:column;label:euiListGroup;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiListGroupStyles = function euiListGroupStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var formMaxWidth = euiFormMaxWidth(euiThemeContext);
  return {
    // Base
    euiListGroup: _ref2,
    // Variants
    flush: _ref,
    bordered: /*#__PURE__*/css("border-radius:", euiTheme.border.radius.medium, ";border:", euiTheme.border.thin, ";;label:bordered;"),
    maxWidthDefault: /*#__PURE__*/css(logicalCSS('max-width', formMaxWidth), ";;label:maxWidthDefault;"),
    // Gutter sizes
    none: /*#__PURE__*/css(";label:none;"),
    s: /*#__PURE__*/css("padding:", euiTheme.size.s, ";gap:", euiTheme.size.s, ";;label:s;"),
    m: /*#__PURE__*/css("padding:", euiTheme.size.base, ";gap:", euiTheme.size.base, ";;label:m;")
  };
};