var _excluded = ["size", "mono", "className", "aria-label"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { useLoadingAriaLabel } from './_loading_strings';
import { euiLoadingChartStyles, euiLoadingChartBarStyles, BARS_COUNT } from './loading_chart.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var SIZES = ['m', 'l', 'xl'];
export var EuiLoadingChart = function EuiLoadingChart(_ref) {
  var _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$mono = _ref.mono,
    mono = _ref$mono === void 0 ? false : _ref$mono,
    className = _ref.className,
    ariaLabel = _ref['aria-label'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiLoadingChart', className);
  var styles = useEuiMemoizedStyles(euiLoadingChartStyles);
  var cssStyles = [styles.euiLoadingChart, styles[size]];
  var barStyles = useEuiMemoizedStyles(euiLoadingChartBarStyles);
  var barCssStyles = [barStyles.euiLoadingChart__bar, mono ? barStyles.mono : barStyles.nonmono, barStyles[size]];
  var defaultAriaLabel = useLoadingAriaLabel();
  return ___EmotionJSX("span", _extends({
    className: classes,
    css: cssStyles,
    role: "progressbar",
    "aria-label": ariaLabel || defaultAriaLabel
  }, rest), Array.from({
    length: BARS_COUNT
  }, function (_, index) {
    return ___EmotionJSX("span", {
      key: index,
      css: barCssStyles
    });
  }));
};
EuiLoadingChart.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  size: PropTypes.any,
  mono: PropTypes.bool
};