/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalCSSWithFallback, logicalBorderRadiusCSS, euiScrollBarStyles } from '../../global_styling';
export var euiMarkdownEditorVariables = function euiMarkdownEditorVariables(_ref) {
  var euiTheme = _ref.euiTheme;
  return {
    minHeight: '150px',
    borderRadius: euiTheme.border.radius.medium,
    barsBackgroundColor: euiTheme.colors.lightestShade
  };
};
export var euiMarkdownEditorStyles = function euiMarkdownEditorStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = euiMarkdownEditorVariables(euiThemeContext),
    minHeight = _euiMarkdownEditorVar.minHeight,
    borderRadius = _euiMarkdownEditorVar.borderRadius;
  return {
    euiMarkdownEditor: /*#__PURE__*/css("display:flex;flex-direction:column;.euiMarkdownEditorToolbar{", logicalBorderRadiusCSS("".concat(borderRadius, " ").concat(borderRadius, " 0 0"), true), ";}.euiMarkdownEditorPreview,.euiMarkdownEditorFooter{", logicalBorderRadiusCSS("0 0 ".concat(borderRadius, " ").concat(borderRadius), true), ";};label:euiMarkdownEditor;"),
    fullHeight: /*#__PURE__*/css(logicalCSS('height', '100%'), " .euiMarkdownEditorTextArea{resize:none;}.euiMarkdownEditorDropZone{", logicalCSS('height', '100%'), ";};label:fullHeight;"),
    euiMarkdownEditorPreview: /*#__PURE__*/css(logicalCSS('min-height', minHeight), " ", logicalCSSWithFallback('overflow-y', 'auto'), " ", euiScrollBarStyles(euiThemeContext), " padding:", euiTheme.size.m, ";border:", euiTheme.border.thin, ";background-color:", euiTheme.colors.emptyShade, ";;label:euiMarkdownEditorPreview;")
  };
};