var _excluded = ["children", "compressed", "id", "isInvalid", "name", "placeholder", "rows", "height", "maxHeight"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { forwardRef, useContext } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiMemoizedStyles } from '../../services';
import { EuiMarkdownContext } from './markdown_context';
import { euiMarkdownEditorTextAreaStyles } from './markdown_editor_text_area.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiMarkdownEditorTextArea = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var children = _ref.children,
    compressed = _ref.compressed,
    id = _ref.id,
    isInvalid = _ref.isInvalid,
    name = _ref.name,
    placeholder = _ref.placeholder,
    rows = _ref.rows,
    height = _ref.height,
    maxHeight = _ref.maxHeight,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiMarkdownContext),
    readOnly = _useContext.readOnly;
  var classes = classNames('euiMarkdownEditorTextArea', {
    'euiMarkdownEditorTextArea-isReadOnly': readOnly
  });
  var styles = useEuiMemoizedStyles(euiMarkdownEditorTextAreaStyles);
  var cssStyles = [styles.euiMarkdownEditorTextArea, readOnly ? styles.readOnly : styles.editable];

  // Ignore invalid empty string style values
  var style = {};
  if (height !== '') {
    style.height = height;
  }
  if (maxHeight !== '') {
    style.maxHeight = maxHeight;
  }
  return ___EmotionJSX("textarea", _extends({
    ref: ref,
    "data-test-subj": "euiMarkdownEditorTextArea",
    style: style,
    className: classes,
    css: cssStyles
  }, rest, {
    rows: 6,
    name: name,
    id: id,
    placeholder: placeholder,
    readOnly: readOnly
  }), children);
});
EuiMarkdownEditorTextArea.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  isInvalid: PropTypes.bool,
  fullWidth: PropTypes.bool,
  compressed: PropTypes.bool,
  height: PropTypes.string.isRequired,
  maxHeight: PropTypes.string.isRequired
};
EuiMarkdownEditorTextArea.displayName = 'EuiMarkdownEditorTextArea';