/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalSizeCSS, euiScrollBarStyles } from '../../global_styling';
import { euiFormControlText, euiFormControlDefaultShadow, euiFormControlFocusStyles } from '../form/form.styles';
import { euiMarkdownEditorVariables } from './markdown_editor.styles';
export var euiMarkdownEditorTextAreaStyles = function euiMarkdownEditorTextAreaStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiMarkdownEditorVar = euiMarkdownEditorVariables(euiThemeContext),
    minHeight = _euiMarkdownEditorVar.minHeight;
  var borderCSS = "\n    border: ".concat(euiTheme.border.thin, ";\n    ").concat(logicalCSS('border-bottom', 'none'), "\n  ");
  return {
    euiMarkdownEditorTextArea: /*#__PURE__*/css(logicalSizeCSS('100%'), " ", logicalCSS('min-height', minHeight), " ", euiScrollBarStyles(euiThemeContext), " resize:vertical;margin:0;padding:", euiTheme.size.m, ";", euiFormControlText(euiThemeContext), " line-height:", euiTheme.font.lineHeightMultiplier, ";;label:euiMarkdownEditorTextArea;"),
    readOnly: /*#__PURE__*/css(borderCSS, " background-color:", euiTheme.colors.emptyShade, ";cursor:default;&:focus{outline:none;};label:readOnly;"),
    editable: /*#__PURE__*/css(euiFormControlDefaultShadow(euiThemeContext), borderCSS, " box-shadow:none;&:focus,.euiMarkdownEditor:focus-within &{", euiFormControlFocusStyles(euiThemeContext), ";};label:editable;")
  };
};