var _excluded = ["exclude"];
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Importing seemingly unused types from `unified` because the definitions
// are exported for two versions of TypeScript (3.4, 4.0) and implicit
// imports during eui.d.ts generation default to the incorrect version (3.4).
// Explicit imports here resolve the version mismatch.

import markdown from 'remark-parse-no-trim';
import emoji from 'remark-emoji';
import breaks from 'remark-breaks';
import highlight from '../remark/remark_prismjs';
import * as MarkdownTooltip from '../markdown_tooltip';
import * as MarkdownCheckbox from '../markdown_checkbox';
import { euiMarkdownLinkValidator, DEFAULT_OPTIONS as LINK_VALIDATOR_DEFAULTS } from '../markdown_link_validator';
var DEFAULT_PARSING_PLUGINS = {
  emoji: [emoji, {
    emoticon: false
  }],
  lineBreaks: [breaks, {}],
  linkValidator: [euiMarkdownLinkValidator, LINK_VALIDATOR_DEFAULTS],
  checkbox: [MarkdownCheckbox.parser, {}],
  tooltip: [MarkdownTooltip.parser, {}]
};
export var getDefaultEuiMarkdownParsingPlugins = function getDefaultEuiMarkdownParsingPlugins() {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var exclude = _ref.exclude,
    parsingConfig = _objectWithoutProperties(_ref, _excluded);
  var parsingPlugins = [[markdown, {}], [highlight, {}]];
  Object.entries(DEFAULT_PARSING_PLUGINS).forEach(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      pluginName = _ref3[0],
      plugin = _ref3[1];
    // Check for plugin exclusions
    if (!(exclude !== null && exclude !== void 0 && exclude.includes(pluginName))) {
      // Check for plugin configuration overrides
      if (pluginName in parsingConfig) {
        parsingPlugins.push([plugin[0], parsingConfig[pluginName]]);
      } else {
        parsingPlugins.push(plugin);
      }
    }
  });
  return parsingPlugins;
};
export var defaultParsingPlugins = getDefaultEuiMarkdownParsingPlugins();