function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { EuiToolTip } from '../../../tool_tip';
import { EuiIcon } from '../../../icon';
import { jsx as ___EmotionJSX } from "@emotion/react";
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "blrk0m-tooltipMarkdownRenderer",
  styles: "transform:translateY(-1px);label:tooltipMarkdownRenderer;"
} : {
  name: "blrk0m-tooltipMarkdownRenderer",
  styles: "transform:translateY(-1px);label:tooltipMarkdownRenderer;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var tooltipMarkdownRenderer = function tooltipMarkdownRenderer(_ref) {
  var content = _ref.content,
    children = _ref.children;
  return ___EmotionJSX("span", null, ___EmotionJSX(EuiToolTip, {
    content: content
  }, ___EmotionJSX("span", null, ___EmotionJSX("strong", null, children), ___EmotionJSX(EuiIcon, {
    type: "questionInCircle"
    // This is to offset the tooltip icon, which isn't perfectly centered
    ,
    css: _ref2
  }))));
};
tooltipMarkdownRenderer.propTypes = {
  type: PropTypes.oneOf(["tooltipPlugin"]).isRequired,
  content: PropTypes.string.isRequired,
  position: PropTypes.shape({
    start: PropTypes.shape({
      line: PropTypes.number.isRequired,
      column: PropTypes.number.isRequired,
      offset: PropTypes.number.isRequired
    }).isRequired,
    end: PropTypes.shape({
      line: PropTypes.number.isRequired,
      column: PropTypes.number.isRequired,
      offset: PropTypes.number.isRequired
    }).isRequired
  }).isRequired
};