function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiModal, EuiModalHeader, EuiModalHeaderTitle, EuiModalBody, EuiModalFooter } from './index';
import { EuiButton } from '../button';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Modal = function Modal() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isModalVisible = _useState2[0],
    setIsModalVisible = _useState2[1];
  var closeModal = function closeModal() {
    return setIsModalVisible(false);
  };
  var showModal = function showModal() {
    return setIsModalVisible(true);
  };
  var modalProps = {
    title: 'Do this thing',
    onClose: closeModal,
    children: React
  };
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiButton, {
    onClick: showModal
  }, "Show confirm modal"), isModalVisible && ___EmotionJSX(EuiModal, modalProps, ___EmotionJSX(EuiModalHeader, null, ___EmotionJSX(EuiModalHeaderTitle, null, "Title of modal")), ___EmotionJSX(EuiModalBody, null, ___EmotionJSX("p", null, "This is a simple modal body")), ___EmotionJSX(EuiModalFooter, null, ___EmotionJSX(EuiButton, {
    onClick: closeModal,
    fill: true
  }, "Close"))));
};
beforeEach(function () {
  cy.mount(___EmotionJSX(Modal, null));
  cy.get('div.euiModal').should('not.exist');
  cy.get('button.euiButton').realClick();
  cy.get('div.euiModal').should('exist');
});
describe('EuiModal', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations when modal is open', function () {
      cy.checkAxe();
    });
    it('has zero violations when modal is closed', function () {
      cy.get('div.euiModalFooter button.euiButton').click();
      cy.get('div.euiModal').should('not.exist');
      cy.checkAxe();
    });
  });
});