/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiShadowXLarge } from '../../themes/amsterdam/global_styling/mixins';
import { euiCanAnimate, euiMaxBreakpoint, euiAnimSlideInUp } from '../../global_styling';
import { euiFormVariables } from '../form/form.styles';
export var euiModalStyles = function euiModalStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiModal: /*#__PURE__*/css(euiShadowXLarge(euiThemeContext), " display:flex;flex-direction:column;max-block-size:75vh;position:relative;background-color:", euiTheme.colors.emptyShade, ";border-radius:", euiTheme.border.radius.medium, ";z-index:", euiTheme.levels.modal, ";min-inline-size:", euiFormVariables(euiThemeContext).maxWidth, ";max-inline-size:calc(100vw - ", euiTheme.size.base, ");overflow:hidden;", euiCanAnimate, "{animation:", euiAnimSlideInUp(euiTheme.size.xxl), " ", euiTheme.animation.slow, " ", euiTheme.animation.bounce, ";}", euiMaxBreakpoint(euiThemeContext, 'm'), "{position:fixed;inset:0;border-radius:0;inline-size:100vw!important;min-inline-size:0!important;max-inline-size:none!important;max-block-size:100vh!important;}&:focus{outline:none;};label:euiModal;"),
    // Variants
    defaultMaxWidth: /*#__PURE__*/css("max-inline-size:min(\n        ", euiTheme.breakpoint.m, "px,\n        calc(100vw - ", euiTheme.size.base, ")\n      );;label:defaultMaxWidth;"),
    confirmation: /*#__PURE__*/css("min-inline-size:", euiFormVariables(euiThemeContext).maxWidth, ";", euiMaxBreakpoint(euiThemeContext, 'm'), "{", euiShadowXLarge(euiThemeContext, {
      reverse: true
    }), " inset-block-start:auto;};label:confirmation;"),
    euiModal__closeIcon: /*#__PURE__*/css("position:absolute;inset-inline-end:", euiTheme.size.xs, ";inset-block-start:", euiTheme.size.xs, ";z-index:3;;label:euiModal__closeIcon;")
  };
};