/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalShorthandCSS } from '../../global_styling';
export var euiModalHeaderStyles = function euiModalHeaderStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiModalHeader: /*#__PURE__*/css("display:flex;justify-content:space-between;align-items:center;flex-grow:0;flex-shrink:0;", logicalShorthandCSS('padding', "".concat(euiTheme.size.l, " ").concat(euiTheme.size.xxl, " ").concat(euiTheme.size.base, " ").concat(euiTheme.size.l)), "&+.euiModalFooter{padding-block-start:", euiTheme.size.s, ";};label:euiModalHeader;")
  };
};