function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { Children, cloneElement, Component } from 'react';
import PropTypes from "prop-types";
import { htmlIdGenerator } from '../../services/accessibility';
export var EuiOutsideClickDetector = /*#__PURE__*/function (_Component) {
  function EuiOutsideClickDetector(props) {
    var _this;
    _classCallCheck(this, EuiOutsideClickDetector);
    _this = _callSuper(this, EuiOutsideClickDetector, [props]);

    // the id is used to identify which EuiOutsideClickDetector
    // is the source of a click event; as the click event bubbles
    // up and reaches the click detector's child component the
    // id value is stamped on the event. This id is inspected
    // in the document's click handler, and if the id doesn't
    // exist or doesn't match this detector's id, then trigger
    // the outsideClick callback.
    //
    // Taking this approach instead of checking if the event's
    // target element exists in this component's DOM sub-tree is
    // necessary for handling clicks originating from children
    // rendered through React's portals (EuiPortal). The id tracking
    // works because React guarantees the event bubbles through the
    // virtual DOM and executes EuiClickDetector's onClick handler,
    // stamping the id even though the event originates outside
    // this component's reified DOM tree.
    // We are working with the assumption that a click event is
    // equivalent to a sequential, compound press and release of
    // the pointing device (mouse, finger, stylus, etc.).
    // A click event's target can be imprecise, as the value will be
    // the closest common ancestor of the press (mousedown, touchstart)
    // and release (mouseup, touchend) events (often <body />) if
    // the the target of each event differs.
    // We need the actual event targets to make the correct decisions
    // about user intention. So, consider the down/start and up/end
    // items below as the deconstruction of a click event.
    _defineProperty(_this, "id", void 0);
    _defineProperty(_this, "capturedDownIds", void 0);
    _defineProperty(_this, "onClickOutside", function (e) {
      var _this$props = _this.props,
        isDisabled = _this$props.isDisabled,
        onOutsideClick = _this$props.onOutsideClick;
      if (isDisabled) {
        _this.capturedDownIds = [];
        return;
      }
      var event = e;
      if (event.euiGeneratedBy && event.euiGeneratedBy.includes(_this.id) || _this.capturedDownIds.includes(_this.id)) {
        _this.capturedDownIds = [];
        return;
      }
      _this.capturedDownIds = [];
      return onOutsideClick(event);
    });
    _defineProperty(_this, "onChildClick", function (event, cb) {
      // to support nested click detectors, build an array
      // of detector ids that have been encountered;
      if (event.nativeEvent.hasOwnProperty('euiGeneratedBy')) {
        event.nativeEvent.euiGeneratedBy.push(_this.id);
      } else {
        event.nativeEvent.euiGeneratedBy = [_this.id];
      }
      if (cb) cb(event);
    });
    _defineProperty(_this, "onChildMouseDown", function (event) {
      _this.onChildClick(event, function (e) {
        var nativeEvent = e.nativeEvent;
        _this.capturedDownIds = nativeEvent.euiGeneratedBy;
        if (_this.props.onMouseDown) _this.props.onMouseDown(e);
        if (_this.props.onTouchStart) _this.props.onTouchStart(e);
      });
    });
    _defineProperty(_this, "onChildMouseUp", function (event) {
      _this.onChildClick(event, function (e) {
        if (_this.props.onMouseUp) _this.props.onMouseUp(e);
        if (_this.props.onTouchEnd) _this.props.onTouchEnd(e);
      });
    });
    _this.id = htmlIdGenerator()();
    _this.capturedDownIds = [];
    return _this;
  }
  _inherits(EuiOutsideClickDetector, _Component);
  return _createClass(EuiOutsideClickDetector, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      document.addEventListener('mouseup', this.onClickOutside);
      document.addEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      document.removeEventListener('mouseup', this.onClickOutside);
      document.removeEventListener('touchend', this.onClickOutside);
    }
  }, {
    key: "render",
    value: function render() {
      var props = _objectSpread(_objectSpread({}, this.props.children.props), {
        onMouseDown: this.onChildMouseDown,
        onTouchStart: this.onChildMouseDown,
        onMouseUp: this.onChildMouseUp,
        onTouchEnd: this.onChildMouseUp
      });
      var child = Children.only(this.props.children);
      return /*#__PURE__*/cloneElement(child, props);
    }
  }]);
}(Component);
EuiOutsideClickDetector.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.element.isRequired,
  onOutsideClick: PropTypes.func.isRequired,
  isDisabled: PropTypes.bool,
  onMouseDown: PropTypes.func,
  onMouseUp: PropTypes.func,
  onTouchStart: PropTypes.func,
  onTouchEnd: PropTypes.func
};