/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../../cypress/support" />

import React from 'react';
import { EuiButton } from '../../button';
import { EuiPageHeader } from './page_header';
import { jsx as ___EmotionJSX } from "@emotion/react";
describe('EuiPageHeader', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(EuiPageHeader, {
      pageTitle: "Page title",
      iconType: "logoKibana",
      description: "This description should be describing the current page as depicted by the page title. It will never extend beneath the right side content.",
      rightSideItems: [___EmotionJSX(EuiButton, {
        fill: true
      }, "Add something"), ___EmotionJSX(EuiButton, null, "Do something")]
    }));
    cy.get('h1.euiTitle').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
});