var _excluded = ["children", "alignment", "restrictWidth", "paddingSize", "grow", "panelled", "color"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import { EuiEmptyPrompt } from '../../empty_prompt';
import { EuiPageSection } from '../../page/page_section';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(_ref) {
  var children = _ref.children,
    _ref$alignment = _ref.alignment,
    alignment = _ref$alignment === void 0 ? 'center' : _ref$alignment,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? false : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    panelled = _ref.panelled,
    color = _ref.color,
    rest = _objectWithoutProperties(_ref, _excluded);
  /**
   * If panelled = true, then either the section or empty prompt must be plain;
   * If color is anything but plain, then it must be the section that is plain;
   * If panelled = true, but color is undefined, then default to the empty prompt being plain;
   */

  var sectionColor;
  var emptyPromptColor;
  if (panelled && color === undefined) {
    sectionColor = 'plain';
    emptyPromptColor = 'subdued';
  } else if (panelled && color !== 'plain') {
    sectionColor = 'plain';
    emptyPromptColor = color;
  } else {
    sectionColor = 'transparent';
    emptyPromptColor = color || 'plain';
  }
  return ___EmotionJSX(EuiPageSection, {
    paddingSize: paddingSize,
    color: sectionColor,
    grow: grow,
    restrictWidth: restrictWidth,
    alignment: alignment
  }, ___EmotionJSX(EuiEmptyPrompt
  // @ts-expect-error Hasn't been updated to use all the new values yet
  , _extends({
    paddingSize: paddingSize,
    color: emptyPromptColor,
    body: children
  }, rest)));
};
_EuiPageEmptyPrompt.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
       * Background color of the section;
       * Usually a lightened form of the brand colors
       */
  color: PropTypes.any,
  /**
       * Padding for all four sides
       */
  paddingSize: PropTypes.any,
  /**
       * Horizontal and/or vertical alignment of the section contents
       */
  alignment: PropTypes.any,
  /**
       * When true the panel will grow in height to fill container if parent is a flex group
       */
  grow: PropTypes.bool,
  /**
       * Passed down to the div wrapper of the section contents
       */
  contentProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
       * Sets which HTML element to render.
       */
  component: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.elementType.isRequired]),
  panelled: PropTypes.bool
};