function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
var _excluded = ["children", "responsive", "restrictWidth", "paddingSize", "grow", "bottomBorder", "offset", "panelled", "contentBorder", "component", "mainProps", "className", "minHeight", "style"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createContext, useContext, useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { _EuiPageOuter as EuiPageOuter } from './outer';
import { _EuiPageInner as EuiPageInner } from './inner';
import { _EuiPageBottomBar as EuiPageBottomBar } from './bottom_bar/page_bottom_bar';
import { _EuiPageEmptyPrompt as EuiPageEmptyPrompt } from './empty_prompt/page_empty_prompt';
import { EuiPageHeader, EuiPageSection, EuiPageSidebar } from '../page';
import { useGeneratedHtmlId } from '../../services';
import { logicalStyles } from '../../global_styling';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var TemplateContext = /*#__PURE__*/createContext({
  sidebar: {},
  section: {},
  header: {},
  emptyPrompt: {},
  bottomBar: {}
});
/**
 * Consumed via `EuiPageTemplate`,
 * it controls and propogates most of the shared props per direct child
 */
export var _EuiPageTemplate = function _EuiPageTemplate(_ref) {
  var children = _ref.children,
    _ref$responsive = _ref.responsive,
    responsive = _ref$responsive === void 0 ? ['xs', 's'] : _ref$responsive,
    _ref$restrictWidth = _ref.restrictWidth,
    restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
    _ref$grow = _ref.grow,
    grow = _ref$grow === void 0 ? true : _ref$grow,
    bottomBorder = _ref.bottomBorder,
    offset = _ref.offset,
    panelled = _ref.panelled,
    contentBorder = _ref.contentBorder,
    component = _ref.component,
    mainProps = _ref.mainProps,
    className = _ref.className,
    _ref$minHeight = _ref.minHeight,
    minHeight = _ref$minHeight === void 0 ? '460px' : _ref$minHeight,
    style = _ref.style,
    rest = _objectWithoutProperties(_ref, _excluded);
  // Used as a target to insert the bottom bar component
  var pageInnerId = useGeneratedHtmlId({
    prefix: 'EuiPageTemplateInner',
    conditionalId: mainProps === null || mainProps === void 0 ? void 0 : mainProps.id
  });

  // Sections include page header
  var _useMemo = useMemo(function () {
      var sidebar = [];
      var sections = [];
      React.Children.toArray(children).forEach(function (child) {
        if (! /*#__PURE__*/React.isValidElement(child)) return; // Skip non-components

        if (child.type === _EuiPageSidebar || child.props.__EMOTION_TYPE_PLEASE_DO_NOT_USE__ === _EuiPageSidebar) {
          sidebar.push(child);
        } else {
          sections.push(child);
        }
      });
      return [sidebar, sections];
    }, [children]),
    _useMemo2 = _slicedToArray(_useMemo, 2),
    sidebar = _useMemo2[0],
    sections = _useMemo2[1];
  var classes = classNames('euiPageTemplate', className);
  var pageStyle = useMemo(function () {
    return logicalStyles(_objectSpread({
      minHeight: grow ? "max(".concat(minHeight, ", 100vh)") : minHeight,
      paddingTop: offset !== null && offset !== void 0 ? offset : 'var(--euiFixedHeadersOffset, 0)'
    }, style));
  }, [minHeight, grow, offset, style]);
  var innerPanelled = panelled !== null && panelled !== void 0 ? panelled : Boolean(sidebar.length > 0);
  var innerBordered = contentBorder !== null && contentBorder !== void 0 ? contentBorder : Boolean(sidebar.length > 0);
  var headerBottomBorder = bottomBorder !== null && bottomBorder !== void 0 ? bottomBorder : sidebar.length ? true : 'extended';
  var templateContext = useMemo(function () {
    return {
      sidebar: {
        paddingSize: paddingSize,
        responsive: responsive
      },
      header: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        bottomBorder: headerBottomBorder
      },
      section: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        color: panelled === false ? 'transparent' : 'plain',
        grow: true
      },
      emptyPrompt: {
        panelled: innerPanelled ? true : panelled,
        grow: true
      },
      bottomBar: {
        restrictWidth: restrictWidth,
        paddingSize: paddingSize,
        // pageInnerId may contain colons that are parsed as pseudo-elements if not escaped
        parent: "#".concat(pageInnerId.replaceAll(':', '\\:'))
      }
    };
  }, [pageInnerId, restrictWidth, responsive, paddingSize, panelled, innerPanelled, headerBottomBorder]);
  return ___EmotionJSX(TemplateContext.Provider, {
    value: templateContext
  }, ___EmotionJSX(EuiPageOuter, _extends({}, rest, {
    responsive: responsive,
    style: pageStyle,
    className: classes
  }), sidebar, ___EmotionJSX(EuiPageInner, _extends({}, mainProps, {
    component: component,
    id: pageInnerId,
    border: innerBordered,
    panelled: innerPanelled,
    responsive: responsive
  }), sections)));
};
_EuiPageTemplate.propTypes = {
  /**
     * Adds `flex-grow: 1` to the whole page for stretching to fit vertically.
     * Must be wrapped inside a flexbox, preferrably with `min-height: 100vh`
     */
  grow: PropTypes.bool,
  /**
     * Changes the `flex-direction` property.
     * Flip to `column` when not including a sidebar.
     */
  direction: PropTypes.any,
  /**
         * Decides at which point the main content wrapper will be 100vw.
         */
  /**
     * When direction is `row`, it will flip to `column` when within these breakpoints.
     */
  responsive: PropTypes.arrayOf(PropTypes.any.isRequired),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
         * Adds a white background and shadow to define the area.
         */
  panelled: PropTypes.bool,
  /**
         * Adjust the overall padding.
         */
  paddingSize: PropTypes.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["extended"])]),
  /**
       * Applies a top or left border to the inner contents
       * to add separation between content and sidebar when a sidebar exists.
       */
  contentBorder: PropTypes.any,
  /**
       * Minimum height in which to enforce scrolling
       */
  minHeight: PropTypes.any,
  /**
       * To account for any fixed elements like headers,
       * pass in the value of the total height of those fixed elements.
       * Otherwise they will be calculated based on the data attributes on the body element.
       */
  offset: PropTypes.number,
  /**
       * Passes through some common HTML attributes to the `main` content wrapper
       */
  mainProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
       * Sets which HTML element to render for the `main` content wrapper
       * @default main
       */
  component: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.elementType.isRequired])
};
var _EuiPageSidebar = function _EuiPageSidebar(props) {
  var _useContext = useContext(TemplateContext),
    sidebar = _useContext.sidebar;
  return ___EmotionJSX(EuiPageSidebar, _extends({}, sidebar, props));
};
_EuiPageSidebar.propTypes = {
  /**
     * Adjust the padding.
     * When using this setting it's best to be consistent throughout all similar usages.
     */
  paddingSize: PropTypes.any,
  /**
     * Renders a fancy little visual in the top left corner of the side bar
     */
  hasEmbellish: PropTypes.bool,
  /**
     * Adds `position: sticky` and affords for any fixed position headers.
     */
  sticky: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    /**
             * To account for any fixed elements like headers,
             * pass in the value of the total height of those fixed elements.
             */
    offset: PropTypes.number
  }).isRequired]),
  /**
     * A minimum width is necessary to maintain size.
     * Be sure to take `paddingSize` into account.
     */
  minWidth: PropTypes.any,
  /**
     * Sets the `minWidth` to 100% when within these breakpoints.
     */
  responsive: PropTypes.arrayOf(PropTypes.any.isRequired),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};
var _EuiPageSection = function _EuiPageSection(props) {
  var _useContext2 = useContext(TemplateContext),
    section = _useContext2.section;
  return ___EmotionJSX(EuiPageSection, _extends({}, section, props));
};
_EuiPageSection.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
       * Background color of the section;
       * Usually a lightened form of the brand colors
       */
  color: PropTypes.any,
  /**
       * Padding for all four sides
       */
  paddingSize: PropTypes.any,
  /**
       * Horizontal and/or vertical alignment of the section contents
       */
  alignment: PropTypes.any,
  /**
       * When true the panel will grow in height to fill container if parent is a flex group
       */
  grow: PropTypes.bool,
  /**
       * Passed down to the div wrapper of the section contents
       */
  contentProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  /**
       * Sets which HTML element to render.
       */
  component: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.elementType.isRequired])
};
var _EuiPageHeader = function _EuiPageHeader(props) {
  var _useContext3 = useContext(TemplateContext),
    header = _useContext3.header;
  return ___EmotionJSX(EuiPageHeader, _extends({}, header, props));
};
_EuiPageHeader.propTypes = {
  /**
     * Adjust the overall padding.
     */
  paddingSize: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  /**
     * Adds a bottom border to separate it from the content after;
     * Passing `extended` will ensure the border touches the sides of the parent container.
     */
  bottomBorder: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["extended"])])
};
var _EuiPageEmptyPrompt = function _EuiPageEmptyPrompt(props) {
  var _useContext4 = useContext(TemplateContext),
    emptyPrompt = _useContext4.emptyPrompt;
  return ___EmotionJSX(EuiPageEmptyPrompt, _extends({}, emptyPrompt, props));
};
_EuiPageEmptyPrompt.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),
  color: PropTypes.any,
  paddingSize: PropTypes.any,
  alignment: PropTypes.any,
  grow: PropTypes.bool,
  contentProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any
  }),
  component: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.elementType.isRequired]),
  panelled: PropTypes.bool
};
var _EuiPageBottomBar = function _EuiPageBottomBar(props) {
  var _useContext5 = useContext(TemplateContext),
    bottomBar = _useContext5.bottomBar;
  return ___EmotionJSX(EuiPageBottomBar, _extends({}, bottomBar, props));
};
_EuiPageBottomBar.propTypes = {
  /**
     * The reference id of the element to insert into
     */
  parent: PropTypes.string,
  /**
     * Sets the max-width of the page,
     * set to `true` to use the default size of `1200px`,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired])
};
export var EuiPageTemplate = Object.assign(_EuiPageTemplate, {
  Sidebar: _EuiPageSidebar,
  Header: _EuiPageHeader,
  Section: _EuiPageSection,
  BottomBar: _EuiPageBottomBar,
  EmptyPrompt: _EuiPageEmptyPrompt
});