/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
export var euiPaginationButtonStyles = function euiPaginationButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiPaginationButton: /*#__PURE__*/css("outline-offset:-", euiTheme.focus.width, ";;label:euiPaginationButton;"),
    // States
    isActive: /*#__PURE__*/css("font-weight:", euiTheme.font.weight.bold, ";color:", euiTheme.colors.primary, ";&,&:hover{cursor:default;text-decoration:underline;};label:isActive;")
  };
};