var _excluded = ["children", "className"],
  _excluded2 = ["children", "className", "direction", "responsive"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useIsWithinBreakpoints } from '../../../services/breakpoint';
import { EuiPanel } from '../panel';
import { euiSplitPanelOuterStyles, euiSplitPanelInnerStyles } from './split_panel.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * Consumed via `EuiSplitPanel.Inner`.
 * Extends most `EuiPanelProps`.
 */
export var _EuiSplitPanelInner = function _EuiSplitPanelInner(_ref) {
  var children = _ref.children,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSplitPanel__inner', className);
  var panelProps = {
    hasShadow: false,
    color: 'transparent',
    borderRadius: 'none',
    hasBorder: false
  };
  return ___EmotionJSX(EuiPanel, _extends({
    element: "div",
    className: classes,
    css: euiSplitPanelInnerStyles.euiSplitPanelInner
  }, panelProps, rest), children);
};
_EuiSplitPanelInner.propTypes = {
  /**
     * Padding for all four sides
     */
  paddingSize: PropTypes.any,
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  grow: PropTypes.bool,
  panelRef: PropTypes.any,
  /**
     * Background color of the panel;
     * Usually a lightened form of the brand colors
     */
  color: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any
};
/**
 * Consumed via `EuiSplitPanel.Outer`.
 * Extends most `EuiPanelProps`.
 */
export var _EuiSplitPanelOuter = function _EuiSplitPanelOuter(_ref2) {
  var children = _ref2.children,
    className = _ref2.className,
    _ref2$direction = _ref2.direction,
    direction = _ref2$direction === void 0 ? 'column' : _ref2$direction,
    _ref2$responsive = _ref2.responsive,
    responsive = _ref2$responsive === void 0 ? ['xs', 's'] : _ref2$responsive,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  var isResponsive = useIsWithinBreakpoints(responsive, !!responsive);
  var styles = euiSplitPanelOuterStyles;
  var cssStyles = [styles.euiSplitPanelOuter, direction === 'row' && !isResponsive ? styles.row : styles.column];
  var classes = classNames('euiSplitPanel', className);
  return ___EmotionJSX(EuiPanel, _extends({
    paddingSize: "none",
    grow: false,
    className: classes,
    css: cssStyles
  }, rest), children);
};
_EuiSplitPanelOuter.propTypes = {
  /**
     * Any number of _EuiSplitPanelInner components
     */
  children: PropTypes.node,
  /**
     * Changes the flex-direction
     */
  direction: PropTypes.oneOf(["column", "row"]),
  /**
     * Stacks row display on small screens.
     * Remove completely with `false` or provide your own list of breakpoint sizes to stack on.
     */
  responsive: PropTypes.oneOfType([PropTypes.oneOf([false]), PropTypes.arrayOf(PropTypes.any.isRequired).isRequired])
};
export var EuiSplitPanel = {
  Outer: _EuiSplitPanelOuter,
  Inner: _EuiSplitPanelInner
};