function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiPopover } from './popover';
import { EuiButtonEmpty } from '../button';
import { EuiText } from '../text';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Popover = function Popover() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPopoverOpen = _useState2[0],
    setIsPopoverOpen = _useState2[1];
  var onButtonClick = function onButtonClick() {
    return setIsPopoverOpen(function (isPopoverOpen) {
      return !isPopoverOpen;
    });
  };
  var closePopover = function closePopover() {
    return setIsPopoverOpen(false);
  };
  var button = ___EmotionJSX(EuiButtonEmpty, {
    iconType: "documentation",
    iconSide: "right",
    onClick: onButtonClick
  }, "How it works");
  var popoverProps = {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover
  };
  return ___EmotionJSX(EuiPopover, popoverProps, ___EmotionJSX(EuiText, {
    style: {
      width: 300
    }
  }, ___EmotionJSX("p", null, "Popover content that\u2019s wider than the default width")));
};
beforeEach(function () {
  cy.mount(___EmotionJSX(Popover, null));
  cy.get('div.euiPopover__panel').should('not.exist');
});
describe('EuiPopover', function () {
  describe('Automated accessibility check', function () {
    it('has zero violations on render', function () {
      cy.checkAxe();
    });
    it('has zero violations when popover is opened', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('exist');
      cy.checkAxe();
    });
    it('has zero violations when popover is closed', function () {
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('exist');
      cy.get('button.euiButtonEmpty').click();
      cy.get('div.euiPopover__panel').should('not.exist');
      cy.checkAxe();
    });
  });
});