var _excluded = ["children", "className", "paddingSize"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useContext } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiPaddingCSS } from '../../global_styling';
import { useEuiTheme } from '../../services';
import { euiPopoverFooterStyles } from './popover_footer.styles';
import { EuiPopoverPanelContext } from './popover_panel/_popover_panel';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiPopoverFooter = function EuiPopoverFooter(_ref) {
  var children = _ref.children,
    className = _ref.className,
    paddingSize = _ref.paddingSize,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _useContext = useContext(EuiPopoverPanelContext),
    panelPadding = _useContext.paddingSize;
  var euiTheme = useEuiTheme();
  var styles = euiPopoverFooterStyles(euiTheme);
  var paddingStyles = useEuiPaddingCSS();
  var cssStyles = [styles.euiPopoverFooter, styles.panelPaddingSizes[panelPadding], paddingStyles[paddingSize || panelPadding] // If a paddingSize is not directly provided, inherit from the EuiPopoverPanel
  ];
  var classes = classNames('euiPopoverFooter', className);
  return ___EmotionJSX("div", _extends({
    css: cssStyles,
    className: classes
  }, rest), children);
};
EuiPopoverFooter.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
         * Customize the all around padding of the popover footer.
         * Leave `undefined` to inherit from the `panelPaddingSize` of the containing EuiPopover
         */
  paddingSize: PropTypes.any
};