/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiFontSize, euiPaddingSize, logicalCSS, logicalShorthandCSS } from '../../global_styling';
export var euiPopoverFooterStyles = function euiPopoverFooterStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiPopoverFooter: /*#__PURE__*/css(euiFontSize(euiThemeContext, 's'), " ", logicalCSS('border-top', euiTheme.border.thin), ";;label:euiPopoverFooter;"),
    // If the popover's containing panel has padding applied,
    // ensure the title expands to cover that padding via negative margins
    panelPaddingSizes: {
      none: /*#__PURE__*/css(";label:none;"),
      xs: /*#__PURE__*/css(panelPaddingOffset(euiThemeContext, 'xs'), ";;label:xs;"),
      s: /*#__PURE__*/css(panelPaddingOffset(euiThemeContext, 's'), ";;label:s;"),
      m: /*#__PURE__*/css(panelPaddingOffset(euiThemeContext, 'm'), ";;label:m;"),
      l: /*#__PURE__*/css(panelPaddingOffset(euiThemeContext, 'l'), ";;label:l;"),
      xl: /*#__PURE__*/css(panelPaddingOffset(euiThemeContext, 'xl'), ";;label:xl;")
    }
  };
};
export var panelPaddingOffset = function panelPaddingOffset(euiThemeContext, size) {
  var panelPaddingSize = euiPaddingSize(euiThemeContext, size);
  return logicalShorthandCSS('margin', "".concat(panelPaddingSize, " -").concat(panelPaddingSize, " -").concat(panelPaddingSize));
};