var _excluded = ["children", "className", "isOpen", "isAttached", "position"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createContext, useMemo } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useEuiTheme } from '../../../services';
import { EuiPanel } from '../../panel/panel';
import { euiPopoverPanelStyles } from './_popover_panel.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
var DEFAULT_PANEL_PADDING_SIZE = 'l';
export var EuiPopoverPanelContext = /*#__PURE__*/createContext({
  paddingSize: DEFAULT_PANEL_PADDING_SIZE
});
/**
 * *INTERNAL ONLY*
 * Purely for re-use of styling
 */
export var EuiPopoverPanel = function EuiPopoverPanel(_ref) {
  var children = _ref.children,
    className = _ref.className,
    isOpen = _ref.isOpen,
    isAttached = _ref.isAttached,
    position = _ref.position,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiPopover__panel', className);
  var euiThemeContext = useEuiTheme();
  var cssStyles = useMemo(function () {
    var styles = euiPopoverPanelStyles(euiThemeContext);
    var colorMode = euiThemeContext.colorMode.toLowerCase();
    var sharedStyles = [styles.euiPopover__panel, styles[colorMode], isOpen && styles.isOpen];
    if (isAttached) {
      return [].concat(sharedStyles, [styles.isAttached.isAttached, position && styles.isAttached[position]]);
    }
    return [].concat(sharedStyles, [styles.hasTransform.hasTransform, isOpen && position && styles.hasTransform[position]]);
  }, [euiThemeContext, isOpen, position, isAttached]);
  return ___EmotionJSX(EuiPopoverPanelContext.Provider, {
    value: {
      paddingSize: rest.paddingSize || DEFAULT_PANEL_PADDING_SIZE
    }
  }, ___EmotionJSX(EuiPanel, _extends({
    className: classes,
    css: cssStyles,
    "data-popover-panel": true,
    "data-popover-open": isOpen || undefined
  }, rest), children));
};
EuiPopoverPanel.propTypes = {
  element: PropTypes.oneOf(["div"]),
  /**
     * Padding for all four sides
     */
  paddingSize: PropTypes.any,
  /**
     * Corner border radius
     */
  borderRadius: PropTypes.any,
  /**
     * When true the panel will grow in height to match `EuiFlexItem`
     */
  grow: PropTypes.bool,
  panelRef: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  isOpen: PropTypes.bool,
  isAttached: PropTypes.bool,
  position: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([null])])
};