/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiPaddingSize, logicalCSS, logicalShorthandCSS } from '../../global_styling';
import { euiTitle } from '../title/title.styles';
export var euiPopoverTitleStyles = function euiPopoverTitleStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiPopoverTitle: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxs'), " ", logicalCSS('border-bottom', euiTheme.border.thin), ";;label:euiPopoverTitle;"),
    // If the popover's containing panel has padding applied,
    // ensure the title expands to cover that padding via negative margins
    panelPaddingSizes: {
      none: /*#__PURE__*/css(";label:none;"),
      xs: /*#__PURE__*/css(getPaddingOffset(euiThemeContext, 'xs'), ";;label:xs;"),
      s: /*#__PURE__*/css(getPaddingOffset(euiThemeContext, 's'), ";;label:s;"),
      m: /*#__PURE__*/css(getPaddingOffset(euiThemeContext, 'm'), ";;label:m;"),
      l: /*#__PURE__*/css(getPaddingOffset(euiThemeContext, 'l'), ";;label:l;"),
      xl: /*#__PURE__*/css(getPaddingOffset(euiThemeContext, 'xl'), ";;label:xl;")
    }
  };
};
var getPaddingOffset = function getPaddingOffset(euiThemeContext, size) {
  var panelPaddingSize = euiPaddingSize(euiThemeContext, size);
  return logicalShorthandCSS('margin', "-".concat(panelPaddingSize, " -").concat(panelPaddingSize, " ").concat(panelPaddingSize));
};