function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React, { useState } from 'react';
import { EuiButton } from '../button';
import { EuiPortal } from './portal';
import { jsx as ___EmotionJSX } from "@emotion/react";
var Portal = function Portal() {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isPortalVisible = _useState2[0],
    setIsPortalVisible = _useState2[1];
  var togglePortal = function togglePortal() {
    setIsPortalVisible(!isPortalVisible);
  };
  var closePortal = function closePortal() {
    setIsPortalVisible(false);
  };
  var customPortal;
  if (isPortalVisible) {
    customPortal = ___EmotionJSX(EuiPortal, null, ___EmotionJSX("div", null, "This is the portal. Click anywhere to close."), ___EmotionJSX(EuiButton, {
      onClick: closePortal
    }, "Close portal"));
  }
  return ___EmotionJSX("div", null, ___EmotionJSX(EuiButton, {
    onClick: togglePortal
  }, "View guide"), customPortal);
};
describe('EuiPortal', function () {
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(Portal, null));
    cy.get('div[data-relative-to-header="above"]').should('not.exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations after the portal is activated', function () {
      cy.get('button[type="button"]').contains('View guide').realClick();
      cy.get('div[data-euiportal="true"]').should('exist');
      cy.checkAxe();
    });
  });
});