function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * NOTE: We can't test this component because Enzyme doesn't support rendering
 * into portals.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import { createPortal } from 'react-dom';
import { EuiNestedThemeContext } from '../../services';
import { usePropsWithComponentDefaults } from '../provider/component_defaults';
import { jsx as ___EmotionJSX } from "@emotion/react";
var INSERT_POSITIONS = ['after', 'before'];
var insertPositions = {
  after: 'afterend',
  before: 'beforebegin'
};
export var EuiPortal = function EuiPortal(props) {
  var propsWithDefaults = usePropsWithComponentDefaults('EuiPortal', props);
  return ___EmotionJSX(EuiPortalClass, propsWithDefaults);
};
EuiPortal.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node.isRequired,
  /**
     * If not specified, `EuiPortal` will insert itself
     * into the end of the `document.body` by default
     */
  insert: PropTypes.shape({
    sibling: PropTypes.any.isRequired,
    position: PropTypes.any.isRequired
  }),
  /**
     * Optional ref callback
     */
  portalRef: PropTypes.func
};
export var EuiPortalClass = /*#__PURE__*/function (_Component) {
  function EuiPortalClass(props) {
    var _this;
    _classCallCheck(this, EuiPortalClass);
    _this = _callSuper(this, EuiPortalClass, [props]);
    _this.state = {
      portalNode: null
    };
    return _this;
  }
  _inherits(EuiPortalClass, _Component);
  return _createClass(EuiPortalClass, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var insert = this.props.insert;
      var portalNode = document.createElement('div');
      portalNode.dataset.euiportal = 'true';
      if (insert == null) {
        // no insertion defined, append to body
        document.body.appendChild(portalNode);
      } else {
        // inserting before or after an element
        var sibling = insert.sibling,
          position = insert.position;
        sibling.insertAdjacentElement(insertPositions[position], portalNode);
      }
      this.setThemeColor(portalNode);
      this.updatePortalRef(portalNode);

      // Update state with portalNode to intentionally trigger component rerender
      // and call createPortal with correct root element in render()
      this.setState({
        portalNode: portalNode
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      var portalNode = this.state.portalNode;
      if (portalNode !== null && portalNode !== void 0 && portalNode.parentNode) {
        portalNode.parentNode.removeChild(portalNode);
      }
      this.updatePortalRef(null);
    }

    // Set the inherited color of the portal based on the wrapping EuiThemeProvider
  }, {
    key: "setThemeColor",
    value: function setThemeColor(portalNode) {
      if (this.context) {
        var _this$context = this.context,
          hasDifferentColorFromGlobalTheme = _this$context.hasDifferentColorFromGlobalTheme,
          colorClassName = _this$context.colorClassName;
        if (hasDifferentColorFromGlobalTheme && this.props.insert == null) {
          portalNode.classList.add(colorClassName);
        }
      }
    }
  }, {
    key: "updatePortalRef",
    value: function updatePortalRef(ref) {
      if (this.props.portalRef) {
        this.props.portalRef(ref);
      }
    }
  }, {
    key: "render",
    value: function render() {
      var portalNode = this.state.portalNode;
      if (!portalNode) {
        return null;
      }
      return /*#__PURE__*/createPortal(this.props.children, portalNode);
    }
  }]);
}(Component);
_defineProperty(EuiPortalClass, "contextType", EuiNestedThemeContext);
EuiPortalClass.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node.isRequired,
  /**
     * If not specified, `EuiPortal` will insert itself
     * into the end of the `document.body` by default
     */
  insert: PropTypes.shape({
    sibling: PropTypes.any.isRequired,
    position: PropTypes.any.isRequired
  }),
  /**
     * Optional ref callback
     */
  portalRef: PropTypes.func
};