function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { createContext, useContext, useMemo } from 'react';
import PropTypes from "prop-types";
import { jsx as ___EmotionJSX } from "@emotion/react";
// Declaring as a static const for reference integrity/reducing rerenders
var emptyDefaults = {};

/*
 * Context
 */
export var EuiComponentDefaultsContext = /*#__PURE__*/createContext(emptyDefaults);

/*
 * Component
 */

export var EuiComponentDefaultsProvider = function EuiComponentDefaultsProvider(_ref) {
  var _ref$componentDefault = _ref.componentDefaults,
    componentDefaults = _ref$componentDefault === void 0 ? emptyDefaults : _ref$componentDefault,
    children = _ref.children;
  return ___EmotionJSX(EuiComponentDefaultsContext.Provider, {
    value: componentDefaults
  }, children);
};

/*
 * Hooks
 */
EuiComponentDefaultsProvider.propTypes = {
  componentDefaults: PropTypes.shape({
    /**
       * Provide a global configuration for EuiPortal's default insertion position.
       */
    EuiPortal: PropTypes.any,
    /**
       * Provide a global configuration for EuiFocusTrap's `gapMode` and `crossFrame` props
       */
    EuiFocusTrap: PropTypes.any,
    /**
       * Provide global settings for EuiTablePagination's props that affect page size
       * / the rows per page selection.
       *
       * These defaults will be inherited all table and grid components that utilize EuiTablePagination.
       */
    EuiTablePagination: PropTypes.any,
    /**
       * Provide a global configuration for EuiTable's `responsiveBreakpoint` prop. Defaults to `'s'`.
       *
       * Defaults will be inherited by all `EuiBasicTable`s and `EuiInMemoryTable`s.
       */
    EuiTable: PropTypes.any
  })
};
export var useComponentDefaults = function useComponentDefaults() {
  return useContext(EuiComponentDefaultsContext);
};

// Merge individual component props with component defaults
export var usePropsWithComponentDefaults = function usePropsWithComponentDefaults(componentName, props) {
  var _context$componentNam;
  var context = useContext(EuiComponentDefaultsContext);
  var componentDefaults = (_context$componentNam = context[componentName]) !== null && _context$componentNam !== void 0 ? _context$componentNam : emptyDefaults;
  return useMemo(function () {
    return _objectSpread(_objectSpread({}, componentDefaults), props);
  }, [componentDefaults, props]);
};