var _excluded = ["isHorizontal", "indicator", "alignIndicator", "accountForScrollbars", "className"],
  _excluded2 = ["registration", "id", "disabled", "onFocus"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useCallback, useMemo, useRef, forwardRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiI18n } from '../i18n';
import { useEuiMemoizedStyles, useGeneratedHtmlId } from '../../services';
import { useEuiResizableContainerContext } from './context';
import { euiResizableButtonStyles } from './resizable_button.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
/**
 * A generic button for indicating/facilitating resizable content,
 * usable outside of the EuiResizableContainer context
 */
export var EuiResizableButton = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var isHorizontal = _ref.isHorizontal,
    _ref$indicator = _ref.indicator,
    indicator = _ref$indicator === void 0 ? 'handle' : _ref$indicator,
    _ref$alignIndicator = _ref.alignIndicator,
    alignIndicator = _ref$alignIndicator === void 0 ? 'center' : _ref$alignIndicator,
    accountForScrollbars = _ref.accountForScrollbars,
    className = _ref.className,
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiResizableButton', className);
  var resizeDirection = isHorizontal ? 'horizontal' : 'vertical';
  var styles = useEuiMemoizedStyles(euiResizableButtonStyles);
  var cssStyles = [styles.euiResizableButton, styles[indicator], styles["".concat(indicator, "Direction")][resizeDirection], styles[resizeDirection], indicator === 'handle' && styles.alignIndicator[alignIndicator], styles.accountForScrollbars[resizeDirection][accountForScrollbars !== null && accountForScrollbars !== void 0 ? accountForScrollbars : 'none']];
  return ___EmotionJSX(EuiI18n, {
    tokens: ['euiResizableButton.horizontalResizerAriaLabel', 'euiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press the left or right arrow keys to adjust panels size', 'Press the up or down arrow keys to adjust panels size']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      horizontalResizerAriaLabel = _ref3[0],
      verticalResizerAriaLabel = _ref3[1];
    return ___EmotionJSX("button", _extends({
      ref: ref,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      css: cssStyles,
      "data-test-subj": "euiResizableButton",
      type: "button"
    }, rest));
  });
});
EuiResizableButton.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  /**
       * Defaults to displaying a resizer for vertical (y-axis) resizing.
       * Set to `true` to display a resizer for horizontal (x-axis) resizing.
       */
  isHorizontal: PropTypes.bool,
  /**
       * By default, EuiResizableButton will show a grab handle to indicate resizability.
       * This indicator can be optionally hidden to show a plain border instead.
       */
  indicator: PropTypes.oneOf(["handle", "border"]),
  /**
       * Allows customizing the alignment of grab `handle` indicators (does nothing for
       * border indicators). Defaults to `center`, but consider using `start` for extremely
       * tall content that scrolls off-screen
       */
  alignIndicator: PropTypes.oneOf(["center", "start", "end"]),
  /**
       * By default, EuiResizableButton will overlap into the panels before/after it.
       * This can occasionally occlude interactive elements like scrollbars. To prevent
       * this overlap, use this prop to remove the overlap for the specified side.
       */
  accountForScrollbars: PropTypes.oneOf(["before", "after", "both"]),
  /**
       * When disabled, the resizer button will be completely hidden
       */
  disabled: PropTypes.bool
};
EuiResizableButton.displayName = 'EuiResizableButton';

/**
 * Resizer button specific to controlled EuiResizableContainer usage
 */

export var EuiResizableButtonControlled = function EuiResizableButtonControlled(_ref4) {
  var registration = _ref4.registration,
    id = _ref4.id,
    disabled = _ref4.disabled,
    _onFocus = _ref4.onFocus,
    rest = _objectWithoutProperties(_ref4, _excluded2);
  var resizerId = useGeneratedHtmlId({
    prefix: 'resizable-button',
    conditionalId: id
  });
  var _useEuiResizableConta = useEuiResizableContainerContext(),
    _useEuiResizableConta2 = _useEuiResizableConta.registry,
    _useEuiResizableConta3 = _useEuiResizableConta2 === void 0 ? {
      resizers: {}
    } : _useEuiResizableConta2,
    resizers = _useEuiResizableConta3.resizers;
  var isDisabled = useMemo(function () {
    var _resizers$resizerId;
    return disabled || ((_resizers$resizerId = resizers[resizerId]) === null || _resizers$resizerId === void 0 ? void 0 : _resizers$resizerId.isDisabled);
  }, [resizers, resizerId, disabled]);
  var previousRef = useRef();
  var onRef = useCallback(function (ref) {
    if (!registration) return;
    if (ref) {
      previousRef.current = ref;
      registration.register({
        id: resizerId,
        ref: ref,
        isFocused: false,
        isDisabled: disabled || false
      });
    } else {
      if (previousRef.current != null) {
        registration.deregister(resizerId);
        previousRef.current = undefined;
      }
    }
  }, [registration, resizerId, disabled]);
  return ___EmotionJSX(EuiResizableButton, _extends({
    id: resizerId,
    ref: onRef,
    disabled: isDisabled,
    onClick: function onClick(e) {
      return e.currentTarget.focus();
    },
    onFocus: function onFocus() {
      return _onFocus === null || _onFocus === void 0 ? void 0 : _onFocus(resizerId);
    }
  }, rest));
};
export var euiResizableButtonWithControls = function euiResizableButtonWithControls(controls) {
  return function (props) {
    return ___EmotionJSX(EuiResizableButtonControlled, _extends({}, controls, props));
  };
};