function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { transparentize } from '../../services';
import { logicalCSS, mathWithUnits, euiCanAnimate } from '../../global_styling';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1fvu7sv-end",
  styles: "align-items:flex-end;label:end;"
} : {
  name: "1fvu7sv-end",
  styles: "align-items:flex-end;label:end;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "h0ntv8-start",
  styles: "align-items:flex-start;label:start;"
} : {
  name: "h0ntv8-start",
  styles: "align-items:flex-start;label:start;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "8391db-center",
  styles: "align-items:center;label:center;"
} : {
  name: "8391db-center",
  styles: "align-items:center;label:center;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiResizableButtonStyles = function euiResizableButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var buttonSize = euiTheme.size.base;
  var negativeMargin = mathWithUnits(buttonSize, function (x) {
    return x / -2;
  });
  var grabHandleWidth = euiTheme.size.m;
  var grabHandleHeight = euiTheme.border.width.thin;
  var transitionSpeed = euiTheme.animation.fast;
  var transition = "".concat(transitionSpeed, " ease");
  return {
    // Creates a resizable indicator (either a grab handle or a plain border) with CSS psuedo-elements.
    // 1. The "grab" handle transforms into a thicker straight line on :hover and :focus
    // 2. Start/end aligned grab handles should have a slight margin offset that disappears on hover/focus
    // 3. CSS hack to smooth out/anti-alias the 1px wide handles at various zoom levels
    euiResizableButton: /*#__PURE__*/css("z-index:1;flex-shrink:0;display:flex;justify-content:center;&:disabled{display:none;}&::before,&::after{content:'';display:block;", euiCanAnimate, "{transition:width ", transition, ",height ", transition, ",margin ", transition, ",background-color ", transition, ";}}&:hover{&::before,&::after{background-color:", euiTheme.colors.mediumShade, ";}}&:focus,&:active{background-color:", transparentize(euiTheme.colors.primary, 0.1), ";&::before,&::after{background-color:", euiTheme.colors.primary, ";", euiCanAnimate, "{transition:width ", transition, ",height ", transition, ";transition-delay:", mathWithUnits(transitionSpeed, function (x) {
      return x / 2;
    }), ";}}};label:euiResizableButton;"),
    horizontal: /*#__PURE__*/css("cursor:col-resize;", logicalCSS('height', '100%'), " ", logicalCSS('width', buttonSize), ";;label:horizontal;"),
    vertical: /*#__PURE__*/css("flex-direction:column;cursor:row-resize;", logicalCSS('width', '100%'), " ", logicalCSS('height', buttonSize), ";;label:vertical;"),
    accountForScrollbars: {
      horizontal: {
        both: /*#__PURE__*/css(";label:both;"),
        before: /*#__PURE__*/css(logicalCSS('margin-right', negativeMargin), ";label:before;"),
        after: /*#__PURE__*/css(logicalCSS('margin-left', negativeMargin), ";label:after;"),
        none: /*#__PURE__*/css(logicalCSS('margin-horizontal', negativeMargin), ";label:none;")
      },
      vertical: {
        both: /*#__PURE__*/css(";label:both;"),
        before: /*#__PURE__*/css(logicalCSS('margin-bottom', negativeMargin), ";label:before;"),
        after: /*#__PURE__*/css(logicalCSS('margin-top', negativeMargin), ";label:after;"),
        none: /*#__PURE__*/css(logicalCSS('margin-vertical', negativeMargin), ";label:none;")
      }
    },
    border: /*#__PURE__*/css("&::before,&::after{background-color:", euiTheme.border.color, ";};label:border;"),
    borderDirection: {
      horizontal: /*#__PURE__*/css("&::before{", logicalCSS('width', euiTheme.border.width.thin), " ", logicalCSS('height', '100%'), ";}&:hover,&:focus,&:active{&::after{", logicalCSS('width', euiTheme.border.width.thin), " ", logicalCSS('height', '100%'), ";}};label:horizontal;"),
      vertical: /*#__PURE__*/css("&::before{", logicalCSS('height', euiTheme.border.width.thin), " ", logicalCSS('width', '100%'), ";}&:hover,&:focus,&:active{&::after{", logicalCSS('height', euiTheme.border.width.thin), " ", logicalCSS('width', '100%'), ";}};label:vertical;")
    },
    handle: /*#__PURE__*/css("gap:", mathWithUnits(grabHandleHeight, function (x) {
      return x * 2;
    }), ";&:hover,&:focus,&:active{gap:0;}", euiCanAnimate, "{transition:gap ", transition, ";}&::before,&::after{background-color:", euiTheme.colors.darkestShade, ";transform:translateZ(0);}&:hover{&::before,&::after{", euiCanAnimate, "{transition-delay:", transitionSpeed, ";}}};label:handle;"),
    handleDirection: {
      horizontal: /*#__PURE__*/css("&::before,&::after{", logicalCSS('width', grabHandleHeight), " ", logicalCSS('height', grabHandleWidth), " margin-block:", euiTheme.size.base, ";}&:hover,&:focus,&:active{&::before,&::after{", logicalCSS('height', '100%'), " margin-block:0;transform:none;}};label:horizontal;"),
      vertical: /*#__PURE__*/css("&::before,&::after{", logicalCSS('height', grabHandleHeight), " ", logicalCSS('width', grabHandleWidth), " margin-inline:", euiTheme.size.base, ";}&:hover,&:focus,&:active{&::before,&::after{", logicalCSS('width', '100%'), " margin-inline:0;transform:none;}};label:vertical;")
    },
    alignIndicator: {
      center: _ref3,
      start: _ref2,
      end: _ref
    }
  };
};