function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, mathWithUnits } from '../../global_styling';
import { euiShadowXSmall, euiSlightShadowHover } from '../../themes/amsterdam';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "fuwsll-euiResizableCollapseButton",
  styles: "z-index:2;position:absolute;&:focus{animation:none;};label:euiResizableCollapseButton;"
} : {
  name: "fuwsll-euiResizableCollapseButton",
  styles: "z-index:2;position:absolute;&:focus{animation:none;};label:euiResizableCollapseButton;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiResizableCollapseButtonStyles = function euiResizableCollapseButtonStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var buttonSize = euiTheme.size.l;
  var centeringOffset = mathWithUnits(buttonSize, function (x) {
    return x / -2;
  }); // Use negative margins instead of transforms to avoid having to override EuiButtonIcon's CSS
  var buttonOffset = euiTheme.size.base;
  return {
    euiResizableCollapseButton: _ref,
    collapsible: {
      collapsible: /*#__PURE__*/css("background:", euiTheme.colors.emptyShade, ";", euiShadowXSmall(euiThemeContext), " &:focus{", euiSlightShadowHover(euiThemeContext), ";};label:collapsible;"),
      horizontal: {
        after: /*#__PURE__*/css(logicalCSS('right', 0), " ", logicalCSS('margin-right', centeringOffset), ";;label:after;"),
        before: /*#__PURE__*/css(logicalCSS('left', 0), " ", logicalCSS('margin-left', centeringOffset), ";;label:before;"),
        middle: /*#__PURE__*/css(logicalCSS('top', '50%'), " ", logicalCSS('margin-top', centeringOffset), ";;label:middle;"),
        top: /*#__PURE__*/css(logicalCSS('top', 0), " ", logicalCSS('margin-top', buttonOffset), ";;label:top;"),
        bottom: /*#__PURE__*/css(logicalCSS('bottom', 0), " ", logicalCSS('margin-bottom', buttonOffset), ";;label:bottom;"),
        // `left/right` aren't valid positions for the horizontal direction,
        // so we're using getters to fall back to the `middle` CSS
        get left() {
          return this.middle;
        },
        get right() {
          return this.middle;
        }
      },
      vertical: {
        after: /*#__PURE__*/css(logicalCSS('top', '100%'), " ", logicalCSS('margin-top', centeringOffset), ";;label:after;"),
        before: /*#__PURE__*/css(logicalCSS('bottom', '100%'), " ", logicalCSS('margin-bottom', centeringOffset), ";;label:before;"),
        middle: /*#__PURE__*/css(logicalCSS('left', '50%'), " ", logicalCSS('margin-left', centeringOffset), ";;label:middle;"),
        left: /*#__PURE__*/css(logicalCSS('left', 0), " ", logicalCSS('margin-left', buttonOffset), ";;label:left;"),
        right: /*#__PURE__*/css(logicalCSS('right', 0), " ", logicalCSS('margin-right', buttonOffset), ";;label:right;"),
        // `top/bottom` aren't valid positions for the horizontal direction,
        // so we're using getters to fall back to the `middle` CSS
        get top() {
          return this.middle;
        },
        get bottom() {
          return this.middle;
        }
      }
    },
    collapsed: {
      // When collapsed, the button itself is the full collapsed area
      // and we use flex to align the icon within
      collapsed: /*#__PURE__*/css("border-radius:0;", logicalCSS('top', 0), ";;label:collapsed;"),
      horizontal: /*#__PURE__*/css(logicalCSS('height', '100%'), ";;label:horizontal;"),
      vertical: /*#__PURE__*/css(logicalCSS('width', '100%'), ";;label:vertical;"),
      horizontalPositions: {
        top: /*#__PURE__*/css(logicalCSS('padding-top', buttonOffset), " align-items:flex-start;;label:top;"),
        bottom: /*#__PURE__*/css(logicalCSS('padding-bottom', buttonOffset), " align-items:flex-end;;label:bottom;"),
        middle: /*#__PURE__*/css(";label:middle;"),
        left: /*#__PURE__*/css(";label:left;"),
        right: /*#__PURE__*/css(";label:right;")
      },
      verticalPositions: {
        left: /*#__PURE__*/css(logicalCSS('padding-left', buttonOffset), " justify-content:flex-start;;label:left;"),
        right: /*#__PURE__*/css(logicalCSS('padding-right', buttonOffset), " justify-content:flex-end;;label:right;"),
        middle: /*#__PURE__*/css(";label:middle;"),
        top: /*#__PURE__*/css(";label:top;"),
        bottom: /*#__PURE__*/css(";label:bottom;")
      }
    }
  };
};