/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/// <reference types="cypress" />
/// <reference types="cypress-real-events" />
/// <reference types="../../../cypress/support" />

import React from 'react';
import { EuiResizableContainer } from './resizable_container';
import { EuiText } from '../text';
import { faker } from '@faker-js/faker';
import { jsx as ___EmotionJSX } from "@emotion/react";
var text = ___EmotionJSX(React.Fragment, null, ___EmotionJSX("p", null, faker.lorem.paragraphs()), ___EmotionJSX("p", null, faker.lorem.paragraphs()), ___EmotionJSX("p", null, faker.lorem.paragraphs()));
describe('Horizontal EuiResizableContainer', function () {
  var HorizontalContainer = function HorizontalContainer() {
    return ___EmotionJSX(EuiResizableContainer, {
      style: {
        height: '200px'
      }
    }, function (EuiResizablePanel, EuiResizableButton) {
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiResizablePanel, {
        initialSize: 50,
        minSize: "30%",
        tabIndex: 0
      }, ___EmotionJSX(EuiText, null, ___EmotionJSX("div", null, text), ___EmotionJSX("a", {
        href: "#",
        "data-test-subj": "hello-world-link"
      }, "Hello world"))), ___EmotionJSX(EuiResizableButton, null), ___EmotionJSX(EuiResizablePanel, {
        initialSize: 50,
        minSize: "200px",
        tabIndex: 0
      }, ___EmotionJSX(EuiText, null, text)));
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(HorizontalContainer, null));
    cy.get('div.euiResizablePanel').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
  });
  describe('Keyboard accessibility check', function () {
    it('has zero violations when first panel is scrolled vertically', function () {
      cy.get('div.euiPanel').first().focus();
      cy.realPress('End');
      cy.get('a[data-test-subj="hello-world-link"]').should('be.visible');
      cy.checkAxe();
    });
    it('has zero violations when second panel is scrolled vertically', function () {
      cy.get('div.euiPanel').last().focus();
      cy.realPress('End');
      cy.realPress('Home');
      cy.checkAxe();
    });
    it('has zero violations when the horizontal panels are resized', function () {
      cy.get('button.euiResizableButton').focus();
      cy.repeatRealPress('ArrowRight', 10);
      cy.checkAxe();
    });
  });
});
describe('Vertical EuiResizableContainer', function () {
  var VerticalContainer = function VerticalContainer() {
    return ___EmotionJSX(EuiResizableContainer, {
      style: {
        height: '400px'
      },
      direction: "vertical"
    }, function (EuiResizablePanel, EuiResizableButton) {
      return ___EmotionJSX(React.Fragment, null, ___EmotionJSX(EuiResizablePanel, {
        initialSize: 60,
        minSize: "40%",
        tabIndex: 0
      }, ___EmotionJSX(EuiText, null, ___EmotionJSX("div", null, text))), ___EmotionJSX(EuiResizableButton, null), ___EmotionJSX(EuiResizablePanel, {
        initialSize: 40,
        minSize: "10%",
        tabIndex: 0
      }, ___EmotionJSX(EuiText, null, ___EmotionJSX("div", null, text))));
    });
  };
  beforeEach(function () {
    cy.viewport(1024, 768); // medium breakpoint
    cy.realMount(___EmotionJSX(VerticalContainer, null));
    cy.get('div.euiResizablePanel').should('exist');
  });
  describe('Automated accessibility check', function () {
    it('has zero violations on first render', function () {
      cy.checkAxe();
    });
    it('has zero violations when the vertical panels are resized', function () {
      cy.get('button.euiResizableButton').focus();
      cy.repeatRealPress('ArrowDown', 10);
      cy.checkAxe();
    });
  });
});