function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { logicalCSS, logicalCSSWithFallback, euiScrollBarStyles } from '../../global_styling';
export var euiResizablePanelStyles = {
  euiResizablePanel: process.env.NODE_ENV === "production" ? {
    name: "15ifdgc-euiResizablePanel",
    styles: "position:relative;label:euiResizablePanel;"
  } : {
    name: "15ifdgc-euiResizablePanel",
    styles: "position:relative;label:euiResizablePanel;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  },
  collapsed: process.env.NODE_ENV === "production" ? {
    name: "11qmbh3-collapsed",
    styles: "overflow:hidden;label:collapsed;"
  } : {
    name: "11qmbh3-collapsed",
    styles: "overflow:hidden;label:collapsed;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  }
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "597kt8-collapsedChildren",
  styles: "*{display:none;};label:collapsedChildren;"
} : {
  name: "597kt8-collapsedChildren",
  styles: "*{display:none;};label:collapsedChildren;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiResizablePanelContentStyles = function euiResizablePanelContentStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    euiResizablePanel__content: /*#__PURE__*/css(logicalCSS('height', '100%'), ";;label:euiResizablePanel__content;"),
    scrollable: /*#__PURE__*/css(euiScrollBarStyles(euiThemeContext), " ", logicalCSSWithFallback('overflow-y', 'auto'), ";;label:scrollable;"),
    collapsedChildren: _ref,
    horizontal: {
      collapsed: /*#__PURE__*/css(logicalCSS('min-width', '0 !important'), ";;label:collapsed;"),
      hasCollapsibleButton: /*#__PURE__*/css(logicalCSS('min-width', "".concat(euiTheme.size.l, " !important")), ";;label:hasCollapsibleButton;")
    },
    vertical: {
      collapsed: /*#__PURE__*/css(logicalCSS('min-height', '0 !important'), ";;label:collapsed;"),
      hasCollapsibleButton: /*#__PURE__*/css(logicalCSS('min-height', "".concat(euiTheme.size.l, " !important")), ";;label:hasCollapsibleButton;")
    }
  };
};