/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
import { euiBreakpoint, logicalCSS, mathWithUnits } from '../../global_styling';
import { euiFormMaxWidth } from '../form/form.styles';
export var euiSearchBar__searchHolder = function euiSearchBar__searchHolder(euiThemeContext) {
  return /*#__PURE__*/css(logicalCSS('min-width', mathWithUnits(euiFormMaxWidth(euiThemeContext), function (x) {
    return x / 2;
  })), ";;label:euiSearchBar__searchHolder;");
};
export var euiSearchBar__filtersHolder = function euiSearchBar__filtersHolder(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return /*#__PURE__*/css(euiBreakpoint(euiThemeContext, ['m', 'l', 'xl']), "{", logicalCSS('max-width', "calc(100% - ".concat(euiTheme.size.base, ")")), ";};label:euiSearchBar__filtersHolder;");
};