var _excluded = ["query", "placeholder", "incremental", "hint"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import React, { useRef, useLayoutEffect } from 'react';
import PropTypes from "prop-types";
import { useEuiI18n } from '../i18n';
import { EuiFieldSearch } from '../form';
import { EuiInputPopover } from '../popover';
import { jsx as ___EmotionJSX } from "@emotion/react";
export var EuiSearchBox = function EuiSearchBox(_ref) {
  var query = _ref.query,
    placeholder = _ref.placeholder,
    incremental = _ref.incremental,
    hint = _ref.hint,
    rest = _objectWithoutProperties(_ref, _excluded);
  var _inputRef = useRef(null);
  useLayoutEffect(function () {
    if (_inputRef.current) {
      _inputRef.current.value = query;
      _inputRef.current.dispatchEvent(new Event('change'));
    }
  }, [query]);
  var defaultPlaceholder = useEuiI18n('euiSearchBox.placeholder', 'Search...');
  var ariaLabelIncremental = useEuiI18n('euiSearchBox.incrementalAriaLabel', 'This is a search bar. As you type, the results lower in the page will automatically filter.');
  var ariaLabelEnter = useEuiI18n('euiSearchBox.ariaLabel', 'This is a search bar. After typing your query, hit enter to filter the results lower in the page.');
  var search = ___EmotionJSX(EuiFieldSearch, _extends({
    inputRef: function inputRef(input) {
      return _inputRef.current = input;
    },
    fullWidth: true,
    defaultValue: query,
    incremental: incremental,
    "aria-label": incremental ? ariaLabelIncremental : ariaLabelEnter,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : defaultPlaceholder,
    onFocus: function onFocus() {
      hint === null || hint === void 0 || hint.setIsVisible(true);
    }
  }, rest));
  if (hint) {
    return ___EmotionJSX(EuiInputPopover, _extends({
      disableFocusTrap: true,
      input: search,
      isOpen: hint.isVisible,
      fullWidth: true,
      closePopover: function closePopover() {
        hint.setIsVisible(false);
      },
      panelProps: {
        'aria-live': undefined,
        'aria-modal': undefined,
        role: undefined,
        tabIndex: -1,
        id: hint.id
      }
    }, hint.popoverProps), hint.content);
  }
  return search;
};
EuiSearchBox.propTypes = {
  query: PropTypes.string.isRequired,
  // This is optional in EuiFieldSearchProps
  onSearch: PropTypes.func.isRequired,
  /**
     * @default Search...
     */
  placeholder: PropTypes.string,
  hint: PropTypes.shape({
    id: PropTypes.string.isRequired,
    isVisible: PropTypes.bool.isRequired,
    setIsVisible: PropTypes.func.isRequired,
    content: PropTypes.node.isRequired,
    popoverProps: PropTypes.any
  })
};