function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { css } from '@emotion/react';
// .euiSelectableList__list requires a static vanilla className
// as it's passed down to react-window's virtualization library
import { css as classNameCss } from '@emotion/css';
import { euiFocusRing, euiYScrollWithShadows, logicalCSS } from '../../../global_styling';
import { euiTitle } from '../../title/title.styles';
import { euiSelectableListItemVariables } from './selectable_list_item.styles';
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1giu8j5-fullHeight",
  styles: "flex-grow:1;label:fullHeight;"
} : {
  name: "1giu8j5-fullHeight",
  styles: "flex-grow:1;label:fullHeight;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
export var euiSelectableListStyles = function euiSelectableListStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var itemVars = euiSelectableListItemVariables(euiThemeContext);
  return {
    euiSelectableList: /*#__PURE__*/css("&:has(:focus-visible){", euiFocusRing(euiThemeContext, 'outset'), ";};label:euiSelectableList;"),
    fullHeight: _ref,
    bordered: /*#__PURE__*/css("overflow:hidden;border:", euiTheme.border.thin, ";border-radius:", euiTheme.border.radius.medium, ";;label:bordered;"),
    euiSelectableList__list: /*#__PURE__*/classNameCss(euiYScrollWithShadows(euiThemeContext), " &:focus,&>ul:focus{outline:none;};label:euiSelectableList__list;"),
    euiSelectableList__groupLabel: /*#__PURE__*/css(euiTitle(euiThemeContext, 'xxxs'), " display:flex;align-items:center;", logicalCSS('border-bottom', itemVars.border), " ", logicalCSS('padding-vertical', itemVars.paddingVertical), " ", logicalCSS('padding-horizontal', itemVars.paddingHorizontal), ";;label:euiSelectableList__groupLabel;")
  };
};