var _excluded = ["children", "className", "disabled", "checked", "isFocused", "showIcons", "prepend", "append", "allowExclusions", "onFocusBadge", "paddingSize", "role", "searchable", "textWrap", "toolTipContent", "toolTipProps", "aria-describedby"],
  _excluded2 = ["children", "className"];
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import classNames from 'classnames';
import PropTypes from "prop-types";
import React, { useState, useEffect, useMemo } from 'react';
import { useEuiMemoizedStyles } from '../../../services';
import { EuiI18n } from '../../i18n';
import { EuiIcon } from '../../icon';
import { EuiScreenReaderOnly } from '../../accessibility';
import { EuiBadge } from '../../badge';
import { EuiToolTip } from '../../tool_tip';
import { euiSelectableListItemStyles } from './selectable_list_item.styles';
import { jsx as ___EmotionJSX } from "@emotion/react";
function resolveIconAndColor(checked) {
  switch (checked) {
    case 'on':
      return {
        icon: 'check',
        color: 'text'
      };
    case 'off':
      return {
        icon: 'cross',
        color: 'text'
      };
    case 'mixed':
      return {
        icon: 'minus',
        color: 'text'
      };
    case undefined:
    default:
      return {
        icon: 'empty'
      };
  }
}
export var PADDING_SIZES = ['none', 's'];
export var EuiSelectableListItem = function EuiSelectableListItem(_ref) {
  var children = _ref.children,
    className = _ref.className,
    disabled = _ref.disabled,
    checked = _ref.checked,
    isFocused = _ref.isFocused,
    _ref$showIcons = _ref.showIcons,
    showIcons = _ref$showIcons === void 0 ? true : _ref$showIcons,
    prepend = _ref.prepend,
    append = _ref.append,
    allowExclusions = _ref.allowExclusions,
    _ref$onFocusBadge = _ref.onFocusBadge,
    onFocusBadge = _ref$onFocusBadge === void 0 ? true : _ref$onFocusBadge,
    _ref$paddingSize = _ref.paddingSize,
    paddingSize = _ref$paddingSize === void 0 ? 's' : _ref$paddingSize,
    _ref$role = _ref.role,
    role = _ref$role === void 0 ? 'option' : _ref$role,
    searchable = _ref.searchable,
    _ref$textWrap = _ref.textWrap,
    textWrap = _ref$textWrap === void 0 ? 'truncate' : _ref$textWrap,
    toolTipContent = _ref.toolTipContent,
    toolTipProps = _ref.toolTipProps,
    _ariaDescribedBy = _ref['aria-describedby'],
    rest = _objectWithoutProperties(_ref, _excluded);
  var classes = classNames('euiSelectableListItem', {
    'euiSelectableListItem-isFocused': isFocused
  }, className);
  var styles = useEuiMemoizedStyles(euiSelectableListItemStyles);
  var cssStyles = [styles.euiSelectableListItem, styles.padding[paddingSize]];
  var textStyles = [styles.euiSelectableListItem__text, styles.textWrap[textWrap]];
  var optionIcon = useMemo(function () {
    if (showIcons) {
      var _resolveIconAndColor = resolveIconAndColor(checked),
        icon = _resolveIconAndColor.icon,
        color = _resolveIconAndColor.color;
      return ___EmotionJSX(EuiIcon, {
        css: styles.euiSelectableListItem__icon,
        className: "euiSelectableListItem__icon",
        color: color,
        type: icon
      });
    }
  }, [showIcons, checked, styles]);
  var prependNode = useMemo(function () {
    if (prepend) {
      return ___EmotionJSX("span", {
        css: styles.euiSelectableListItem__prepend,
        className: "euiSelectableListItem__prepend"
      }, prepend);
    }
  }, [prepend, styles]);
  var onFocusBadgeNode = useMemo(function () {
    var defaultOnFocusBadgeProps = {
      'aria-hidden': true,
      iconType: 'returnKey',
      iconSide: 'left',
      color: 'hollow'
    };
    if (onFocusBadge === true) {
      return ___EmotionJSX(EuiBadge, _extends({
        className: "euiSelectableListItem__onFocusBadge"
      }, defaultOnFocusBadgeProps));
    } else if (typeof onFocusBadge !== 'boolean' && !!onFocusBadge) {
      var _children = onFocusBadge.children,
        _className = onFocusBadge.className,
        restBadgeProps = _objectWithoutProperties(onFocusBadge, _excluded2);
      return ___EmotionJSX(EuiBadge, _extends({
        className: classNames('euiSelectableListItem__onFocusBadge', _className)
      }, defaultOnFocusBadgeProps, restBadgeProps), _children);
    }
  }, [onFocusBadge]);
  var showOnFocusBadge = !!(isFocused && !disabled && onFocusBadgeNode);
  var appendNode = useMemo(function () {
    if (append || showOnFocusBadge) {
      return ___EmotionJSX("span", {
        css: styles.euiSelectableListItem__append,
        className: "euiSelectableListItem__append"
      }, append, " ", showOnFocusBadge ? onFocusBadgeNode : null);
    }
  }, [append, showOnFocusBadge, onFocusBadgeNode, styles]);
  var screenReaderText = useMemo(function () {
    var state;
    var instructions;
    var screenReaderStrings = {
      checked: {
        state: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.checkedOption",
          default: "Checked option."
        }),
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.checkOptionInstructions",
          default: "To check this option, press Enter."
        })
      },
      unchecked: {
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.uncheckOptionInstructions",
          default: "To uncheck this option, press Enter."
        })
      },
      excluded: {
        state: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.excludedOption",
          default: "Excluded option."
        }),
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.excludeOptionInstructions",
          default: "To exclude this option, press Enter."
        })
      },
      mixed: {
        state: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOption",
          default: "Mixed (indeterminate) option."
        }),
        instructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOptionInstructions",
          default: "To check this option for all, press Enter once."
        }),
        uncheckInstructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOptionUncheckInstructions",
          default: "To uncheck this option for all, press Enter twice."
        }),
        excludeInstructions: ___EmotionJSX(EuiI18n, {
          token: "euiSelectableListItem.mixedOptionExcludeInstructions",
          default: "To exclude this option for all, press Enter twice."
        })
      }
    };
    switch (checked) {
      case 'on':
        state = screenReaderStrings.checked.state;
        instructions = allowExclusions ? screenReaderStrings.excluded.instructions : searchable ? screenReaderStrings.unchecked.instructions : undefined;
        break;
      case 'off':
        state = screenReaderStrings.excluded.state;
        instructions = screenReaderStrings.unchecked.instructions;
        break;
      case 'mixed':
        state = screenReaderStrings.mixed.state;
        instructions = ___EmotionJSX(React.Fragment, null, screenReaderStrings.mixed.instructions, ' ', allowExclusions ? screenReaderStrings.mixed.excludeInstructions : screenReaderStrings.mixed.uncheckInstructions);
        break;
      case undefined:
      default:
        instructions = allowExclusions || searchable ? screenReaderStrings.checked.instructions : undefined;
        break;
    }
    return state || instructions ? ___EmotionJSX(EuiScreenReaderOnly, null, ___EmotionJSX("div", null, state || instructions ? '. ' : null, state, state && instructions ? ' ' : null, instructions)) : null;
  }, [checked, searchable, allowExclusions]);

  // aria-checked is intended to be used with role="checkbox" but
  // the MDN documentation lists it as a possibility for role="option".
  // See https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked
  // and https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/option_role
  var ariaChecked = useMemo(function () {
    var rolesThatCanBeMixed = ['option', 'checkbox', 'menuitemcheckbox'];
    var rolesThatCanBeChecked = [].concat(rolesThatCanBeMixed, ['radio', 'menuitemradio', 'switch']);
    if (!rolesThatCanBeChecked.includes(role)) return undefined;
    switch (checked) {
      case 'on':
      case 'off':
        return true;
      case 'mixed':
        if (rolesThatCanBeMixed.includes(role)) {
          return 'mixed';
        } else {
          return false;
        }
      default:
        return false;
    }
  }, [role, checked]);
  var hasToolTip = !!toolTipContent && !disabled;
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    tooltipRef = _useState2[0],
    setTooltipRef = _useState2[1]; // Needs to be state and not a ref to trigger useEffect
  var _useState3 = useState(_ariaDescribedBy),
    _useState4 = _slicedToArray(_useState3, 2),
    ariaDescribedBy = _useState4[0],
    setAriaDescribedBy = _useState4[1];

  // Manually trigger the tooltip on keyboard focus
  useEffect(function () {
    if (!tooltipRef) return;
    if (isFocused) {
      tooltipRef.showToolTip();
    } else {
      tooltipRef.hideToolTip();
    }
  }, [isFocused, tooltipRef]);

  // Manually set the `aria-describedby` id on the <li> wrapper
  useEffect(function () {
    if (tooltipRef) {
      var tooltipId = tooltipRef.state.id;
      setAriaDescribedBy(classNames(tooltipId, _ariaDescribedBy));
    }
  }, [tooltipRef, _ariaDescribedBy]);
  var content = ___EmotionJSX("span", {
    css: styles.euiSelectableListItem__content,
    className: "euiSelectableListItem__content"
  }, optionIcon, prependNode, ___EmotionJSX("span", {
    css: textStyles,
    className: "euiSelectableListItem__text"
  }, children, screenReaderText), appendNode);
  return ___EmotionJSX("li", _extends({
    role: role,
    "aria-disabled": disabled,
    "aria-checked": ariaChecked // Whether the item is "checked"
    ,
    "aria-selected": !disabled && isFocused // Whether the item has keyboard focus per W3 spec
    ,
    css: cssStyles,
    className: classes
  }, rest, {
    "aria-describedby": ariaDescribedBy
  }), hasToolTip ? ___EmotionJSX(EuiToolTip, _extends({
    ref: setTooltipRef,
    content: toolTipContent,
    anchorClassName: "eui-fullWidth",
    position: "left"
  }, toolTipProps), content) : content);
};
EuiSelectableListItem.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  css: PropTypes.any,
  children: PropTypes.node,
  /**
       * Applies an icon and visual styling to activated items
       */
  checked: PropTypes.any,
  /**
       * Shows icons based on `checked` type
       */
  showIcons: PropTypes.bool,
  /**
       * Highlights the item for pseudo focus
       */
  isFocused: PropTypes.bool,
  disabled: PropTypes.bool,
  prepend: PropTypes.node,
  append: PropTypes.node,
  allowExclusions: PropTypes.bool,
  /**
       * When enabled by setting to either `true` or passing custom a custom badge,
       * shows a hollow badge as an append (far right) when the item is focused.
       * The default content when `true` is `↩ to select/deselect/include/exclude`
       */
  onFocusBadge: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.shape({
    /**
       * Accepts any string from our icon library
       */
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "agentApp", "aggregate", "analyzeEvent", "annotation", "anomalyChart", "anomalySwimLane", "apmApp", "apmTrace", "appSearchApp", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "arrowStart", "arrowEnd", "article", "asterisk", "at", "auditbeatApp", "beaker", "bell", "bellSlash", "beta", "bolt", "boxesHorizontal", "boxesVertical", "branch", "branchUser", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "casesApp", "changePointDetection", "check", "checkInCircleFilled", "cheer", "classificationJob", "clickLeft", "clickRight", "clock", "clockCounter", "cloudDrizzle", "cloudStormy", "cloudSunny", "cluster", "codeApp", "color", "compute", "console", "consoleApp", "container", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "contrast", "contrastHigh", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createGenericJob", "createGeoJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crossInCircle", "crosshairs", "currency", "cut", "dashboardApp", "dataVisualizer", "database", "desktop", "devToolsApp", "diff", "discoverApp", "discuss", "document", "documentEdit", "documentation", "documents", "dot", "dotInCircle", "doubleArrowLeft", "doubleArrowRight", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorChecklist", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignLeft", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "endpoint", "eql", "eraser", "error", "errorFilled", "esqlVis", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "fieldStatistics", "filebeatApp", "filter", "filterExclude", "filterIgnore", "filterInclude", "filterInCircle", "flag", "fleetApp", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "grabOmnidirectional", "gradient", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "index", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "indexTemporary", "infinity", "inputOutput", "inspect", "invert", "ip", "key", "keyboard", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "kubernetesNode", "kubernetesPod", "launch", "layers", "lensApp", "lettering", "lineDashed", "lineDotted", "lineSolid", "link", "list", "listAdd", "lock", "lockOpen", "logPatternAnalysis", "logRateAnalysis", "logoAWS", "logoAWSMono", "logoAerospike", "logoApache", "logoAppSearch", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticStack", "logoElasticsearch", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoVulnerabilityManagement", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logsApp", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithExclamation", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "minusInSquare", "mobile", "monitoringApp", "moon", "move", "namespace", "nested", "newChat", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "palette", "paperClip", "partial", "pause", "payment", "pencil", "percent", "pin", "pinFilled", "pipeBreaks", "pipelineApp", "pipeNoBreaks", "pivot", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "plusInSquare", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "section", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "sessionViewer", "shard", "share", "singleMetricViewer", "snowflake", "sortAscending", "sortDescending", "sortDown", "sortLeft", "sortRight", "sortUp", "sortable", "spaces", "spacesApp", "sparkles", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "sun", "swatchInput", "symlink", "tableDensityCompact", "tableDensityExpanded", "tableDensityNormal", "tableOfContents", "tag", "tear", "temperature", "timeline", "timelineWithArrow", "timelionApp", "timeRefresh", "timeslider", "training", "transitionLeftIn", "transitionLeftOut", "transitionTopIn", "transitionTopOut", "trash", "unfold", "unlink", "upgradeAssistantApp", "uptimeApp", "user", "userAvatar", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visVega", "visVisualBuilder", "visualizeApp", "vulnerabilityManagementApp", "warning", "warningFilled", "alert", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenAlias", "tokenAnnotation", "tokenArray", "tokenBinary", "tokenBoolean", "tokenClass", "tokenCompletionSuggester", "tokenConstant", "tokenDate", "tokenDimension", "tokenElement", "tokenEnum", "tokenEnumMember", "tokenEvent", "tokenException", "tokenField", "tokenFile", "tokenFlattened", "tokenFunction", "tokenGeo", "tokenHistogram", "tokenInterface", "tokenIP", "tokenJoin", "tokenKey", "tokenKeyword", "tokenMethod", "tokenMetricCounter", "tokenMetricGauge", "tokenModule", "tokenNamespace", "tokenNested", "tokenNull", "tokenNumber", "tokenObject", "tokenOperator", "tokenPackage", "tokenParameter", "tokenPercolator", "tokenProperty", "tokenRange", "tokenRankFeature", "tokenRankFeatures", "tokenRepo", "tokenSearchType", "tokenSemanticText", "tokenShape", "tokenString", "tokenStruct", "tokenSymbol", "tokenTag", "tokenText", "tokenTokenCount", "tokenVariable", "tokenVectorDense", "tokenDenseVector", "tokenVectorSparse"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),
    /**
       * The side of the badge the icon should sit
       */
    iconSide: PropTypes.any,
    /**
       * Accepts either our palette colors (primary, success ..etc) or a hex value `#FFFFFF`, `#000`.
       */
    color: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.string.isRequired]),
    /**
       * Will override any color passed through the `color` prop.
       */
    isDisabled: PropTypes.bool,
    /**
       * Props passed to the close button.
       */
    closeButtonProps: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,
    css: PropTypes.any,
    /**
       * Will apply an onclick to icon within the badge
       */
    iconOnClick: PropTypes.func,
    /**
       * Aria label applied to the iconOnClick button
       */
    iconOnClickAriaLabel: PropTypes.any,
    /**
       * Will apply an onclick to the badge itself
       */
    onClick: PropTypes.func,
    /**
       * Aria label applied to the onClick button
       */
    onClickAriaLabel: PropTypes.any,
    href: PropTypes.string,
    target: PropTypes.string,
    rel: PropTypes.string
  }).isRequired]),
  /**
       * Padding for the list items.
       */
  paddingSize: PropTypes.any,
  /**
       * Whether the `EuiSelectable` instance is searchable.
       * When true, the Space key will not toggle selection, as it will type into the search box instead. Screen reader instructions will be added instructing users to use the Enter key to select items.
       * When false, the Space key will toggle item selection. No extra screen reader instructions will be added, as Space to toggle is a generally standard for most select/checked elements.
       */
  searchable: PropTypes.bool,
  /**
       * Attribute applied the option `<li>`.
       * If set to a role that allows [aria-checked](https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-checked),
       * `aria-checked` will be automatically configured.
       */
  role: PropTypes.any,
  /**
       * How to handle long text within the item.
       * Wrapping only works if virtualization is off.
       */
  textWrap: PropTypes.oneOf(["truncate", "wrap"]),
  /**
       * Optional custom tooltip content for the button
       */
  toolTipContent: PropTypes.node,
  /**
       * Optional props to pass to the underlying **[EuiToolTip](/#/display/tooltip)**
       */
  toolTipProps: PropTypes.any
};